/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport.legstar.wmq.transformer;

import com.legstar.coxb.transform.HostTransformException;
import com.legstar.mq.mqcih.Mqcih;
import com.legstar.mq.mqcih.bind.MqcihTransformers;
import java.io.UnsupportedEncodingException;
import java.util.Map;
import org.mule.api.MuleMessage;
import org.mule.api.transformer.Transformer;
import org.mule.api.transformer.TransformerException;
import org.mule.transport.legstar.LegstarConnector;
import org.mule.transport.legstar.LegstarConnectorHelper;
import org.mule.transport.legstar.cixs.transformer.AbstractHostToExecRequestMuleTransformer;
import org.mule.transport.legstar.config.HostCredentials;
import org.mule.transport.legstar.config.HostProgram;

public class HostToMqcihExecRequestMuleTransformer
extends AbstractHostToExecRequestMuleTransformer {
    private int _waitInterval = -1;
    private static final int MQCIH_SYNC_ON_RETURN = 4;
    private static final int MQCIH_REPLY_WITHOUT_NULLS = 2;
    private static final int CICS_PROGRAM_NAME_LEN = 8;

    @Override
    public byte[] wrapHostData(byte[] hostData, MuleMessage esbMessage) throws TransformerException {
        try {
            HostCredentials hostCredentials = null;
            if (this.getEndpoint() == null) {
                hostCredentials = LegstarConnectorHelper.getHostCredentials(esbMessage);
            } else {
                LegstarConnector connector = (LegstarConnector)this.getEndpoint().getConnector();
                hostCredentials = connector.getHostCredentials(esbMessage);
            }
            byte[] mqcihBytes = this.getMqcihBytes(this.getHostProgram(), hostCredentials);
            byte[] result = new byte[mqcihBytes.length + 8 + hostData.length];
            System.arraycopy(mqcihBytes, 0, result, 0, mqcihBytes.length);
            byte[] programBytes = "        ".getBytes(this.getHostCharset());
            System.arraycopy(this.getHostProgram().getName().getBytes(this.getHostCharset()), 0, programBytes, 0, this.getHostProgram().getName().length());
            System.arraycopy(programBytes, 0, result, mqcihBytes.length, 8);
            System.arraycopy(hostData, 0, result, mqcihBytes.length + 8, hostData.length);
            return result;
        }
        catch (TransformerException e) {
            throw new TransformerException(this.getI18NMessages().hostTransformFailure(), (Transformer)this, (Throwable)e);
        }
        catch (UnsupportedEncodingException e) {
            throw new TransformerException(this.getI18NMessages().encodingFailure(this.getHostCharset()), (Transformer)this, (Throwable)e);
        }
    }

    @Override
    public byte[] wrapHostData(Map<String, byte[]> hostDataMap, MuleMessage esbMessage) throws TransformerException {
        throw new TransformerException(this.getI18NMessages().noMultiPartSupportFailure(), (Transformer)this);
    }

    @Override
    public void setMessageProperties(MuleMessage esbMessage) {
        esbMessage.setCorrelationId("AMQ!NEW_SESSION_CORRELID");
        esbMessage.setOutboundProperty("JMS_IBM_Format", (Object)"MQCICS  ");
        esbMessage.setOutboundProperty("JMS_IBM_Character_Set", (Object)this.getCCSID(this.getHostCharset()));
    }

    private int getCCSID(String hostCharset) {
        if (hostCharset.equals("IBM-Thai")) {
            return 838;
        }
        if (hostCharset.startsWith("IBM")) {
            return Integer.parseInt(hostCharset.substring(3));
        }
        if (hostCharset.startsWith("x-IBM")) {
            return Integer.parseInt(hostCharset.substring(5));
        }
        return 500;
    }

    public final byte[] getMqcihBytes(HostProgram hostProgram, HostCredentials hostCredentials) throws TransformerException {
        try {
            Mqcih mqcih = new Mqcih();
            mqcih.setMqcihOutputdatalength(hostProgram.getMaxDataLength() + 8);
            mqcih.setMqcihAuthenticator(new String(hostCredentials.getPassword()));
            if (this.getWaitInterval() > -1) {
                mqcih.setMqcihGetwaitinterval(this.getWaitInterval());
            }
            mqcih.setMqcihFlags(6);
            MqcihTransformers mqcihTransformers = new MqcihTransformers();
            return mqcihTransformers.toHost((Object)mqcih, this.getHostCharset());
        }
        catch (HostTransformException e) {
            throw new TransformerException(this.getI18NMessages().hostTransformFailure(), (Transformer)this, (Throwable)e);
        }
    }

    public final int getWaitInterval() {
        return this._waitInterval;
    }

    public final void setWaitInterval(int waitInterval) {
        this._waitInterval = waitInterval;
    }
}

