/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport.legstar.transformer;

import com.legstar.coxb.transform.AbstractTransformers;
import com.legstar.coxb.transform.AbstractXmlTransformers;
import com.legstar.coxb.transform.HostTransformException;
import com.legstar.coxb.transform.HostTransformStatus;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.commons.io.IOUtils;
import org.mule.api.MuleMessage;
import org.mule.api.transformer.Transformer;
import org.mule.api.transformer.TransformerException;
import org.mule.transformer.types.DataTypeFactory;
import org.mule.transport.legstar.transformer.AbstractHostMuleTransformer;
import org.mule.transport.legstar.transformer.AbstractHostXmlMuleTransformer;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public abstract class AbstractHostToXmlMuleTransformer
extends AbstractHostXmlMuleTransformer {
    private AbstractHostMuleTransformer.HolderSetter holderSetter;
    private JAXBContext mJaxbContext = null;
    private Marshaller mXmlMarshaller = null;

    public AbstractHostToXmlMuleTransformer(AbstractXmlTransformers xmlBindingTransformers) {
        super(xmlBindingTransformers);
        this.registerSourceType(DataTypeFactory.create(InputStream.class));
        this.registerSourceType(DataTypeFactory.BYTE_ARRAY);
        this.setReturnDataType(DataTypeFactory.TEXT_STRING);
    }

    public AbstractHostToXmlMuleTransformer(Map<String, AbstractXmlTransformers> xmlBindingTransformersMap) {
        super(xmlBindingTransformersMap);
        this.registerSourceType(DataTypeFactory.create(Map.class));
        this.setReturnDataType(DataTypeFactory.TEXT_STRING);
    }

    public AbstractHostToXmlMuleTransformer(List<AbstractTransformers> bindingTransformersList, AbstractHostMuleTransformer.HolderSetter holderSetter) {
        super(bindingTransformersList);
        this.registerSourceType(DataTypeFactory.create(InputStream.class));
        this.registerSourceType(DataTypeFactory.BYTE_ARRAY);
        this.setReturnDataType(DataTypeFactory.TEXT_STRING);
        this.holderSetter = holderSetter;
        try {
            this.mJaxbContext = JAXBContext.newInstance((Class[])new Class[]{holderSetter.getHolderType()});
            this.mXmlMarshaller = this.mJaxbContext.createMarshaller();
        }
        catch (JAXBException e) {
            throw new IllegalArgumentException("Unable to create JAXB context", e);
        }
    }

    @Override
    public Object hostTransform(MuleMessage esbMessage, String encoding) throws TransformerException {
        try {
            Object src = esbMessage.getPayload();
            if (src instanceof byte[]) {
                return this.toXml((byte[])src, this.getHostCharset(esbMessage));
            }
            if (src instanceof InputStream) {
                return this.toXml(IOUtils.toByteArray((InputStream)((InputStream)src)), this.getHostCharset(esbMessage));
            }
            if (src instanceof Map) {
                return this.toXml((Map)src, this.getHostCharset(esbMessage));
            }
            return null;
        }
        catch (HostTransformException e) {
            throw new TransformerException(this.getI18NMessages().hostTransformFailure(), (Transformer)this, (Throwable)e);
        }
        catch (Exception e) {
            throw new TransformerException(this.getI18NMessages().hostTransformFailure(), (Transformer)this, (Throwable)e);
        }
    }

    public Object toXml(byte[] hostBytes, String hostCharset) throws HostTransformException {
        if (this.getXmlBindingTransformers() != null) {
            StringWriter writer = new StringWriter();
            this.getXmlBindingTransformers().toXml(hostBytes, (Writer)writer, hostCharset);
            return writer.toString();
        }
        if (this.getBindingTransformersList() != null) {
            return this.toXml(this.getBindingTransformersList(), hostBytes, hostCharset);
        }
        return null;
    }

    public Object toXml(Map<String, byte[]> hostParts, String hostCharset) throws TransformerException {
        try {
            HashMap<String, String> transformedParts = new HashMap<String, String>();
            for (Map.Entry<String, byte[]> hostPart : hostParts.entrySet()) {
                StringWriter writer = new StringWriter();
                this.getXmlBindingTransformersMap().get(hostPart.getKey()).toXml(hostPart.getValue(), (Writer)writer, hostCharset);
                transformedParts.put(hostPart.getKey(), writer.toString());
            }
            return this.createXmlHolder(transformedParts);
        }
        catch (HostTransformException e) {
            throw new TransformerException(this.getI18NMessages().hostTransformFailure(), (Transformer)this, (Throwable)e);
        }
    }

    public Object toXml(List<AbstractTransformers> transformers, byte[] hostBytes, String hostCharset) throws HostTransformException {
        int replyBytePos = 0;
        int index = 0;
        HostTransformStatus status = new HostTransformStatus();
        for (AbstractTransformers xf : transformers) {
            this.holderSetter.set(xf.toJava(hostBytes, replyBytePos, hostCharset, status), index);
            replyBytePos += status.getHostBytesProcessed();
            ++index;
        }
        return this.createXmlHolder(this.holderSetter.getHolder());
    }

    public Object createXmlHolder(Map<String, String> transformedParts) throws TransformerException {
        try {
            DocumentBuilderFactory docFactory = DocumentBuilderFactory.newInstance();
            docFactory.setNamespaceAware(true);
            DocumentBuilder docBuilder = docFactory.newDocumentBuilder();
            Document docResult = docBuilder.newDocument();
            Element elHolder = docResult.createElementNS(this.getHolderQName().getNamespaceURI(), this.getHolderQName().getLocalPart());
            docResult.appendChild(elHolder);
            for (Map.Entry<String, String> entry : transformedParts.entrySet()) {
                this.mergeXml(docBuilder, entry.getValue(), entry.getKey(), docResult, elHolder);
            }
            StringWriter writer = new StringWriter();
            TransformerFactory tfactory = TransformerFactory.newInstance();
            javax.xml.transform.Transformer serializer = tfactory.newTransformer();
            serializer.transform(new DOMSource(docResult), new StreamResult(writer));
            return writer.toString();
        }
        catch (ParserConfigurationException e) {
            throw new TransformerException(this.getI18NMessages().hostTransformFailure(), (Transformer)this, (Throwable)e);
        }
        catch (TransformerException e) {
            throw new TransformerException(this.getI18NMessages().hostTransformFailure(), (Transformer)this, (Throwable)e);
        }
        catch (TransformerConfigurationException e) {
            throw new TransformerException(this.getI18NMessages().hostTransformFailure(), (Transformer)this, (Throwable)e);
        }
        catch (javax.xml.transform.TransformerException e) {
            throw new TransformerException(this.getI18NMessages().hostTransformFailure(), (Transformer)this, (Throwable)e);
        }
    }

    public void mergeXml(DocumentBuilder docBuilder, String partXml, String partID, Document docResult, Element elHolder) throws TransformerException {
        try {
            Document docInput = docBuilder.parse(new InputSource(new StringReader(partXml)));
            NodeList nodeList = docInput.getElementsByTagName(partID);
            if (nodeList.getLength() > 0) {
                Node nodeInDocInput = nodeList.item(0);
                Node nodeInDocResult = docResult.importNode(nodeInDocInput, true);
                elHolder.appendChild(nodeInDocResult);
            }
        }
        catch (DOMException e) {
            throw new TransformerException(this.getI18NMessages().hostTransformFailure(), (Transformer)this, (Throwable)e);
        }
        catch (SAXException e) {
            throw new TransformerException(this.getI18NMessages().hostTransformFailure(), (Transformer)this, (Throwable)e);
        }
        catch (IOException e) {
            throw new TransformerException(this.getI18NMessages().hostTransformFailure(), (Transformer)this, (Throwable)e);
        }
    }

    private Object createXmlHolder(Object javaResult) throws HostTransformException {
        try {
            StringWriter writer = new StringWriter();
            this.mXmlMarshaller.marshal(javaResult, (Writer)writer);
            return writer.toString();
        }
        catch (JAXBException e) {
            throw new HostTransformException((Exception)((Object)e));
        }
    }

    public QName getHolderQName() throws TransformerException {
        throw new TransformerException(this.getI18NMessages().noMultiPartSupportFailure(), (Transformer)this);
    }
}

