/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport.legstar.transformer;

import com.legstar.coxb.transform.AbstractTransformers;
import com.legstar.coxb.transform.HostTransformException;
import com.legstar.coxb.transform.HostTransformStatus;
import java.io.InputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.IOUtils;
import org.mule.api.MuleMessage;
import org.mule.api.transformer.Transformer;
import org.mule.api.transformer.TransformerException;
import org.mule.transformer.types.DataTypeFactory;
import org.mule.transport.legstar.transformer.AbstractHostJavaMuleTransformer;
import org.mule.transport.legstar.transformer.AbstractHostMuleTransformer;

public abstract class AbstractHostToJavaMuleTransformer
extends AbstractHostJavaMuleTransformer {
    private AbstractHostMuleTransformer.HolderSetter holderSetter;

    public AbstractHostToJavaMuleTransformer(AbstractTransformers bindingTransformers) {
        super(bindingTransformers);
        this.registerSourceType(DataTypeFactory.create(InputStream.class));
        this.registerSourceType(DataTypeFactory.BYTE_ARRAY);
    }

    public AbstractHostToJavaMuleTransformer(Map<String, AbstractTransformers> bindingTransformersMap) {
        super(bindingTransformersMap);
        this.registerSourceType(DataTypeFactory.create(Map.class));
    }

    public AbstractHostToJavaMuleTransformer(List<AbstractTransformers> bindingTransformersList, AbstractHostMuleTransformer.HolderSetter holderSetter) {
        super(bindingTransformersList);
        this.registerSourceType(DataTypeFactory.create(InputStream.class));
        this.registerSourceType(DataTypeFactory.BYTE_ARRAY);
        this.holderSetter = holderSetter;
    }

    @Override
    public Object hostTransform(MuleMessage esbMessage, String encoding) throws TransformerException {
        try {
            Object src = esbMessage.getPayload();
            if (src instanceof byte[]) {
                return this.toJava((byte[])src, this.getHostCharset(esbMessage));
            }
            if (src instanceof InputStream) {
                return this.toJava(IOUtils.toByteArray((InputStream)((InputStream)src)), this.getHostCharset(esbMessage));
            }
            if (src instanceof Map) {
                return this.toJava((Map)src, this.getHostCharset(esbMessage));
            }
            return null;
        }
        catch (HostTransformException e) {
            throw new TransformerException(this.getI18NMessages().hostTransformFailure(), (Transformer)this, (Throwable)e);
        }
        catch (Exception e) {
            throw new TransformerException(this.getI18NMessages().hostTransformFailure(), (Transformer)this, (Throwable)e);
        }
    }

    public Object toJava(byte[] hostBytes, String hostCharset) throws HostTransformException {
        if (this.getBindingTransformers() != null) {
            return this.getBindingTransformers().toJava(hostBytes, hostCharset);
        }
        if (this.getBindingTransformersList() != null) {
            return this.toJava(this.getBindingTransformersList(), hostBytes, hostCharset);
        }
        return null;
    }

    public Object toJava(Map<String, byte[]> hostParts, String hostCharset) throws TransformerException {
        try {
            HashMap<String, Object> transformedParts = new HashMap<String, Object>();
            for (Map.Entry<String, byte[]> hostPart : hostParts.entrySet()) {
                transformedParts.put(hostPart.getKey(), this.getBindingTransformersMap().get(hostPart.getKey()).toJava(hostPart.getValue(), hostCharset));
            }
            return this.createHolder(transformedParts);
        }
        catch (HostTransformException e) {
            throw new TransformerException(this.getI18NMessages().hostTransformFailure(), (Transformer)this, (Throwable)e);
        }
    }

    public Object toJava(List<AbstractTransformers> transformers, byte[] hostBytes, String hostCharset) throws HostTransformException {
        int replyBytePos = 0;
        int index = 0;
        HostTransformStatus status = new HostTransformStatus();
        for (AbstractTransformers xf : transformers) {
            this.holderSetter.set(xf.toJava(hostBytes, replyBytePos, hostCharset, status), index);
            replyBytePos += status.getHostBytesProcessed();
            ++index;
        }
        return this.holderSetter.getHolder();
    }

    public Object createHolder(Map<String, Object> transformedParts) throws TransformerException {
        throw new TransformerException(this.getI18NMessages().noMultiPartSupportFailure(), (Transformer)this);
    }
}

