/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport.legstar.tcp;

import java.net.Socket;
import org.apache.commons.pool.KeyedPoolableObjectFactory;
import org.apache.commons.pool.impl.GenericKeyedObjectPool;
import org.mule.api.MuleContext;
import org.mule.api.MuleEvent;
import org.mule.api.MuleMessage;
import org.mule.api.endpoint.ImmutableEndpoint;
import org.mule.api.lifecycle.InitialisationException;
import org.mule.transport.legstar.LegstarConnector;
import org.mule.transport.legstar.LegstarConnectorHelper;
import org.mule.transport.legstar.config.HostCredentials;
import org.mule.transport.legstar.tcp.LegstarTcpProtocol;
import org.mule.transport.legstar.tcp.LegstarTcpSocketFactory;
import org.mule.transport.legstar.tcp.LegstarTcpSocketKey;
import org.mule.transport.tcp.AbstractTcpSocketFactory;
import org.mule.transport.tcp.TcpConnector;
import org.mule.transport.tcp.TcpProtocol;

public class LegstarTcpConnector
extends TcpConnector
implements LegstarConnector {
    public static final String LEGSTARTCP = "legstar-tcp";
    private String _hostUserID = "";
    private String _hostPassword = "";
    private GenericKeyedObjectPool _socketsPool = new GenericKeyedObjectPool();

    public LegstarTcpConnector(MuleContext context) {
        super(context);
        this.setSocketFactory((AbstractTcpSocketFactory)new LegstarTcpSocketFactory(this));
        this.setTcpProtocol((TcpProtocol)new LegstarTcpProtocol());
    }

    public void doInitialise() throws InitialisationException {
        this._socketsPool.setFactory((KeyedPoolableObjectFactory)this.getSocketFactory());
        this._socketsPool.setTestOnBorrow(true);
        this._socketsPool.setTestOnReturn(false);
        this._socketsPool.setMaxActive(1);
        this._socketsPool.setWhenExhaustedAction((byte)1);
    }

    public void doDisconnect() throws Exception {
        this._socketsPool.clear();
        super.doDisconnect();
    }

    public void doDispose() {
        try {
            this._socketsPool.close();
        }
        catch (Exception e) {
            this.logger.warn((Object)("Failed to close dispatcher socket pool: " + e.getMessage()));
        }
    }

    public String getProtocol() {
        return LEGSTARTCP;
    }

    public boolean isSyncEnabled(String protocol) {
        return protocol.equals(this.getProtocol());
    }

    protected Socket getSocket(MuleEvent event, ImmutableEndpoint endpoint) throws Exception {
        HostCredentials hostCredentials = this.getHostCredentials(event.getMessage());
        LegstarTcpSocketKey socketKey = new LegstarTcpSocketKey(endpoint, hostCredentials);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("borrowing socket for " + (Object)((Object)socketKey) + "/" + socketKey.hashCode()));
        }
        Socket socket = (Socket)this._socketsPool.borrowObject((Object)socketKey);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("borrowed socket, " + (socket.isClosed() ? "closed" : "open") + "; debt " + this._socketsPool.getNumActive()));
        }
        return socket;
    }

    protected void releaseSocket(Socket socket, MuleEvent event, ImmutableEndpoint endpoint) throws Exception {
        HostCredentials hostCredentials = this.getHostCredentials(event.getMessage());
        LegstarTcpSocketKey socketKey = new LegstarTcpSocketKey(endpoint, hostCredentials);
        this._socketsPool.returnObject((Object)socketKey, (Object)socket);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("returning socket for " + (Object)((Object)socketKey) + "/" + socketKey.hashCode()));
            this.logger.debug((Object)("returned socket; debt " + this._socketsPool.getNumActive()));
        }
    }

    @Override
    public HostCredentials getHostCredentials(MuleMessage message) {
        return LegstarConnectorHelper.getHostCredentials(this, message);
    }

    @Override
    public String getHostUserID() {
        return this._hostUserID;
    }

    @Override
    public String getHostPassword() {
        return this._hostPassword;
    }

    @Override
    public void setHostUserID(String userID) {
        this._hostUserID = userID;
    }

    @Override
    public void setHostPassword(String password) {
        this._hostPassword = password;
    }
}

