/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport.legstar.http;

import java.io.IOException;
import java.net.URI;
import org.apache.commons.httpclient.HostConfiguration;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.api.ExceptionPayload;
import org.mule.api.MuleEvent;
import org.mule.api.MuleException;
import org.mule.api.MuleMessage;
import org.mule.api.endpoint.OutboundEndpoint;
import org.mule.api.transformer.TransformerException;
import org.mule.api.transport.PropertyScope;
import org.mule.transport.http.HttpClientMessageDispatcher;

public class LegstarHttpMessageDispatcher
extends HttpClientMessageDispatcher {
    private static final String LEGSTAR_HTTP_CONTENT_TYPE = "application/octet-stream";
    private static final String LEGSTAR_HTTP_HEADER_TRACE_MODE = "CICSTraceMode";
    private final Log _log = LogFactory.getLog(((Object)((Object)this)).getClass());

    public LegstarHttpMessageDispatcher(OutboundEndpoint endpoint) {
        super(endpoint);
    }

    public final HttpMethod getMethod(MuleEvent event) throws TransformerException {
        if (this._log.isDebugEnabled()) {
            this._log.debug((Object)("Creating http method for endpoint " + this.getEndpoint()));
        }
        HttpMethod httpMethod = super.getMethod(event);
        httpMethod.removeRequestHeader("Content-Type");
        httpMethod.addRequestHeader("Content-Type", LEGSTAR_HTTP_CONTENT_TYPE);
        if (this.isHostTraceOn(event.getMessage()) || this._log.isDebugEnabled()) {
            httpMethod.addRequestHeader(LEGSTAR_HTTP_HEADER_TRACE_MODE, "true");
        }
        return httpMethod;
    }

    protected MuleMessage getResponseFromMethod(HttpMethod httpMethod, ExceptionPayload ep) throws IOException, MuleException {
        MuleMessage message = super.getResponseFromMethod(httpMethod, ep);
        message.removeProperty("Content-Length", PropertyScope.OUTBOUND);
        message.removeProperty("Content-Type", PropertyScope.OUTBOUND);
        return message;
    }

    protected HostConfiguration getHostConfig(URI uri) throws Exception {
        URI httpUri = new URI(uri.toString().replace("legstar:", "http:"));
        return super.getHostConfig(httpUri);
    }

    public boolean isHostTraceOn(MuleMessage esbMessage) {
        return (Boolean)esbMessage.getInboundProperty("LEGSTAR_HOST_TRACE_ON", (Object)false);
    }
}

