/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport.legstar.http;

import java.io.UnsupportedEncodingException;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.api.MuleContext;
import org.mule.api.MuleEvent;
import org.mule.api.MuleMessage;
import org.mule.api.endpoint.ImmutableEndpoint;
import org.mule.transport.http.HttpConnector;
import org.mule.transport.legstar.LegstarConnector;
import org.mule.transport.legstar.LegstarConnectorHelper;
import org.mule.transport.legstar.config.HostCredentials;

public class LegstarHttpConnector
extends HttpConnector
implements LegstarConnector {
    public static final String LEGSTARHTTP = "legstar";
    private String _hostUserID = "";
    private String _hostPassword = "";
    private final Log _log = LogFactory.getLog(this.getClass());

    public LegstarHttpConnector(MuleContext context) {
        super(context);
    }

    public final String getProtocol() {
        return LEGSTARHTTP;
    }

    @Override
    public HostCredentials getHostCredentials(MuleMessage message) {
        return LegstarConnectorHelper.getHostCredentials(this, message);
    }

    @Override
    public String getHostUserID() {
        return this._hostUserID;
    }

    @Override
    public String getHostPassword() {
        return this._hostPassword;
    }

    @Override
    public void setHostUserID(String userID) {
        this._hostUserID = userID;
    }

    @Override
    public void setHostPassword(String password) {
        this._hostPassword = password;
    }

    protected void setupClientAuthorization(MuleEvent event, HttpMethod httpMethod, HttpClient client, ImmutableEndpoint endpoint) throws UnsupportedEncodingException {
        super.setupClientAuthorization(event, httpMethod, client, endpoint);
        HostCredentials hostCredentials = this.getHostCredentials(event.getMessage());
        if (httpMethod.getRequestHeader("Authorization") == null && hostCredentials.getUserInfo() != null) {
            if (this._log.isDebugEnabled()) {
                this._log.debug((Object)("adding security header " + hostCredentials.toString()));
            }
            StringBuffer header = new StringBuffer(128);
            header.append("Basic ");
            header.append(new String(Base64.encodeBase64((byte[])hostCredentials.getUserInfo().getBytes(endpoint.getEncoding()))));
            httpMethod.addRequestHeader("Authorization", header.toString());
        }
    }
}

