/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport.legstar.config;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.Properties;
import org.mule.transport.legstar.config.HostContainer;
import org.mule.transport.legstar.config.HostProgram;

public final class ConfigUtils {
    private ConfigUtils() {
    }

    public static Properties loadFromPropFile(String propFileName) throws IOException {
        Properties properties = new Properties();
        InputStream in = Thread.currentThread().getContextClassLoader().getResourceAsStream(propFileName);
        if (in == null) {
            throw new FileNotFoundException(propFileName);
        }
        properties.load(in);
        in.close();
        return properties;
    }

    public static int getInt(Properties props, String key) {
        String s = props.getProperty(key, "0");
        return Integer.parseInt(s);
    }

    public static HostProgram getHostProgram(String propertyFileName) throws IOException {
        HostProgram hostProgram = new HostProgram();
        Properties props = ConfigUtils.loadFromPropFile(propertyFileName);
        hostProgram.setName(props.getProperty("CICSProgramName"));
        hostProgram.setMaxDataLength(ConfigUtils.getInt(props, "CICSLength"));
        hostProgram.setDataLength(ConfigUtils.getInt(props, "CICSDataLength"));
        hostProgram.setChannelName(props.getProperty("CICSChannel"));
        ConfigUtils.loadContainer(props, hostProgram.getInputContainers(), "CICSInContainers", "CICSInContainersLength");
        ConfigUtils.loadContainer(props, hostProgram.getOutputContainers(), "CICSOutContainers", "CICSOutContainersLength");
        return hostProgram;
    }

    public static void loadContainer(Properties props, List<HostContainer> containers, String nameKey, String lengthKey) {
        int i = 1;
        String name = props.getProperty(nameKey + '_' + i);
        while (name != null && name.length() > 0) {
            HostContainer container = new HostContainer();
            container.setName(name);
            container.setMaxLength(ConfigUtils.getInt(props, lengthKey + '_' + i));
            containers.add(container);
            name = props.getProperty(nameKey + '_' + ++i);
        }
    }
}

