/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport.legstar.cixs.transformer;

import com.legstar.messaging.CommareaPart;
import com.legstar.messaging.ContainerPart;
import com.legstar.messaging.HeaderPartException;
import com.legstar.messaging.HostMessageFormatException;
import com.legstar.messaging.LegStarHeaderPart;
import com.legstar.messaging.LegStarMessage;
import com.legstar.messaging.LegStarMessagePart;
import java.util.Map;
import org.json.JSONException;
import org.mule.api.MuleMessage;
import org.mule.api.transformer.Transformer;
import org.mule.api.transformer.TransformerException;
import org.mule.transport.legstar.cixs.transformer.AbstractHostToExecRequestMuleTransformer;
import org.mule.transport.legstar.config.HostProgram;

public class HostToLegstarExecRequestMuleTransformer
extends AbstractHostToExecRequestMuleTransformer {
    @Override
    public byte[] wrapHostData(byte[] hostData, MuleMessage esbMessage) throws TransformerException {
        try {
            LegStarMessage legStarMessage = this.createLegStarMessage(this.getHostProgram());
            legStarMessage.addDataPart((LegStarMessagePart)new CommareaPart(hostData));
            return legStarMessage.toByteArray();
        }
        catch (TransformerException e) {
            throw new TransformerException(this.getI18NMessages().hostTransformFailure(), (Transformer)this, (Throwable)e);
        }
        catch (HostMessageFormatException e) {
            throw new TransformerException(this.getI18NMessages().hostMessageFormatFailure(), (Transformer)this, (Throwable)e);
        }
    }

    @Override
    public byte[] wrapHostData(Map<String, byte[]> hostDataMap, MuleMessage esbMessage) throws TransformerException {
        try {
            LegStarMessage legStarMessage = this.createLegStarMessage(this.getHostProgram());
            for (Map.Entry<String, byte[]> entry : hostDataMap.entrySet()) {
                legStarMessage.addDataPart((LegStarMessagePart)new ContainerPart(entry.getKey(), entry.getValue()));
            }
            return legStarMessage.toByteArray();
        }
        catch (HostMessageFormatException e) {
            throw new TransformerException(this.getI18NMessages().hostMessageFormatFailure(), (Transformer)this, (Throwable)e);
        }
    }

    @Override
    public void setMessageProperties(MuleMessage esbMessage) {
        esbMessage.setCorrelationId(this.getHostCompatibleCorrelationId(esbMessage.getCorrelationId()));
    }

    public final LegStarMessage createLegStarMessage(HostProgram hostProgram) throws TransformerException {
        try {
            LegStarMessage legStarMessage = new LegStarMessage();
            legStarMessage.setHeaderPart(new LegStarHeaderPart(0, this.getHostProgram().toJSONHost()));
            return legStarMessage;
        }
        catch (HeaderPartException e) {
            throw new TransformerException(this.getI18NMessages().hostTransformFailure(), (Transformer)this, (Throwable)e);
        }
        catch (JSONException e) {
            throw new TransformerException(this.getI18NMessages().hostTransformFailure(), (Transformer)this, (Throwable)e);
        }
    }
}

