/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport.legstar.wmq.transformer;

import com.legstar.messaging.HeaderPartException;
import com.legstar.messaging.HostMessageFormatException;
import com.legstar.mq.mqcih.Mqcih;
import com.legstar.mq.mqcih.bind.MqcihTransformers;
import org.mule.api.MuleMessage;
import org.mule.api.transformer.Transformer;
import org.mule.api.transformer.TransformerException;
import org.mule.transport.legstar.cixs.transformer.AbstractExecReplyToHostMuleTransformer;

public class MqcihExecReplyToHostMuleTransformer
extends AbstractExecReplyToHostMuleTransformer {
    private static final int CICS_PROGRAM_NAME_LEN = 8;

    public byte[] hostTransform(MuleMessage esbMessage, String outputEncoding) throws TransformerException {
        try {
            byte[] mqcihHost = esbMessage.getPayloadAsBytes();
            MqcihTransformers mqcihTransformers = new MqcihTransformers();
            Mqcih mqcihJava = mqcihTransformers.toJava(mqcihHost, this.getHostCharset());
            if (mqcihJava.getMqcihCompcode() != 0) {
                throw new TransformerException(this.getI18NMessages().mqcihNonZeroCompCode(mqcihJava.getMqcihCompcode()), (Transformer)this);
            }
            if (!mqcihJava.getMqcihFormat().equals("")) {
                throw new TransformerException(this.getI18NMessages().mqcihFormatNotNone(mqcihJava.getMqcihFormat()), (Transformer)this);
            }
            byte[] programNameHost = new byte[8];
            System.arraycopy(mqcihHost, mqcihJava.getMqcihStruclength(), programNameHost, 0, 8);
            byte[] payload = new byte[mqcihHost.length - mqcihJava.getMqcihStruclength() - 8];
            System.arraycopy(mqcihHost, mqcihJava.getMqcihStruclength() + 8, payload, 0, payload.length);
            return payload;
        }
        catch (HeaderPartException e) {
            throw new TransformerException(this.getI18NMessages().hostMessageFormatFailure(), (Transformer)this, (Throwable)e);
        }
        catch (HostMessageFormatException e) {
            throw new TransformerException(this.getI18NMessages().hostMessageFormatFailure(), (Transformer)this, (Throwable)e);
        }
        catch (Exception e) {
            throw new TransformerException(this.getI18NMessages().hostMessageFormatFailure(), (Transformer)this, (Throwable)e);
        }
    }
}

