/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport.legstar.transformer;

import com.legstar.coxb.transform.AbstractTransformers;
import com.legstar.coxb.transform.AbstractXmlTransformers;
import com.legstar.coxb.transform.HostTransformException;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Source;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamSource;
import org.mule.api.MuleMessage;
import org.mule.api.transformer.Transformer;
import org.mule.api.transformer.TransformerException;
import org.mule.transformer.types.DataTypeFactory;
import org.mule.transport.legstar.transformer.AbstractHostMuleTransformer;
import org.mule.transport.legstar.transformer.AbstractHostXmlMuleTransformer;
import org.mule.transport.legstar.transformer.IObjectToHostTransformer;
import org.w3c.dom.Document;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public abstract class AbstractXmlToHostMuleTransformer
extends AbstractHostXmlMuleTransformer
implements IObjectToHostTransformer {
    private static final String XML_ENCODING = "UTF-8";
    private AbstractHostMuleTransformer.HolderGetter holderGetter;
    private JAXBContext mJaxbContext = null;
    private Unmarshaller mXmlUnmarshaller = null;

    public AbstractXmlToHostMuleTransformer(AbstractXmlTransformers xmlBindingTransformers) {
        super(xmlBindingTransformers);
        this.registerSourceType(DataTypeFactory.STRING);
        this.registerSourceType(DataTypeFactory.create(InputStream.class));
        this.registerSourceType(DataTypeFactory.BYTE_ARRAY);
        this.setReturnDataType(DataTypeFactory.BYTE_ARRAY);
    }

    public AbstractXmlToHostMuleTransformer(Map<String, AbstractXmlTransformers> xmlBindingTransformersMap) {
        super(xmlBindingTransformersMap);
        this.registerSourceType(DataTypeFactory.STRING);
        this.registerSourceType(DataTypeFactory.create(InputStream.class));
        this.registerSourceType(DataTypeFactory.BYTE_ARRAY);
        this.setReturnDataType(DataTypeFactory.create(Map.class));
    }

    public AbstractXmlToHostMuleTransformer(List<AbstractTransformers> bindingTransformersList, AbstractHostMuleTransformer.HolderGetter holderGetter) {
        super(bindingTransformersList);
        this.registerSourceType(DataTypeFactory.STRING);
        this.registerSourceType(DataTypeFactory.create(InputStream.class));
        this.registerSourceType(DataTypeFactory.BYTE_ARRAY);
        this.setReturnDataType(DataTypeFactory.BYTE_ARRAY);
        this.holderGetter = holderGetter;
        try {
            this.mJaxbContext = JAXBContext.newInstance(holderGetter.getHolderType());
            this.mXmlUnmarshaller = this.mJaxbContext.createUnmarshaller();
        }
        catch (JAXBException e) {
            throw new IllegalArgumentException("Unable to create JAXB context", e);
        }
    }

    @Override
    public Object hostTransform(MuleMessage esbMessage, String encoding) throws TransformerException {
        try {
            String hostCharset = this.getHostCharset(esbMessage);
            if (this.getXmlBindingTransformers() != null) {
                byte[] hostData = this.getXmlBindingTransformers().toHost(this.getXmlSource(esbMessage.getPayload()), hostCharset);
                return hostData;
            }
            if (this.getBindingTransformersList() != null) {
                Object holder = this.createHolder(this.getXmlSource(esbMessage.getPayload()));
                int index = 0;
                int hostDataSize = 0;
                byte[][] hostBytesArray = new byte[this.getBindingTransformersList().size()][];
                for (AbstractTransformers xf : this.getBindingTransformersList()) {
                    hostBytesArray[index] = xf.toHost(this.holderGetter.get(holder, index), hostCharset);
                    hostDataSize += hostBytesArray[index].length;
                    ++index;
                }
                byte[] hostData = new byte[hostDataSize];
                int requestBytePos = 0;
                for (int i = 0; i < hostBytesArray.length; ++i) {
                    System.arraycopy(hostBytesArray[i], 0, hostData, requestBytePos, hostBytesArray[i].length);
                    requestBytePos += hostBytesArray[i].length;
                }
                return hostData;
            }
            if (this.getXmlBindingTransformersMap() != null) {
                Document holderDoc = this.getDocument(esbMessage.getPayload());
                HashMap<String, byte[]> hostDataMap = new HashMap<String, byte[]>();
                for (Map.Entry<String, AbstractXmlTransformers> entry : this.getXmlBindingTransformersMap().entrySet()) {
                    hostDataMap.put(entry.getKey(), entry.getValue().toHost(this.getXmlFragmentFromHolder(holderDoc, entry.getKey()), hostCharset));
                }
                return hostDataMap;
            }
            return null;
        }
        catch (HostTransformException e) {
            throw new TransformerException(this.getI18NMessages().hostTransformFailure(), (Transformer)this, (Throwable)e);
        }
    }

    public Source getXmlSource(Object payload) throws TransformerException {
        try {
            if (payload instanceof String) {
                return new StreamSource(new StringReader((String)payload));
            }
            if (payload instanceof byte[]) {
                return new StreamSource(new InputStreamReader((InputStream)new ByteArrayInputStream((byte[])payload), XML_ENCODING));
            }
            if (payload instanceof InputStream) {
                return new StreamSource(new InputStreamReader((InputStream)payload, XML_ENCODING));
            }
            throw new TransformerException(this.getI18NMessages().payloadNotXmlSource(), (Transformer)this);
        }
        catch (UnsupportedEncodingException e) {
            throw new TransformerException(this.getI18NMessages().encodingFailure(XML_ENCODING), (Transformer)this, (Throwable)e);
        }
    }

    public InputSource getXmlInputSource(Object payload) throws TransformerException {
        if (payload instanceof String) {
            return new InputSource(new StringReader((String)payload));
        }
        if (payload instanceof byte[]) {
            return new InputSource(new ByteArrayInputStream((byte[])payload));
        }
        if (payload instanceof InputStream) {
            return new InputSource((InputStream)payload);
        }
        throw new TransformerException(this.getI18NMessages().payloadNotXmlSource(), (Transformer)this);
    }

    public Document getDocument(Object payload) throws TransformerException {
        try {
            DocumentBuilderFactory docFactory = DocumentBuilderFactory.newInstance();
            docFactory.setNamespaceAware(true);
            DocumentBuilder docBuilder = docFactory.newDocumentBuilder();
            return docBuilder.parse(this.getXmlInputSource(payload));
        }
        catch (TransformerException e) {
            throw new TransformerException(this.getI18NMessages().payloadNotXmlSource(), (Transformer)this);
        }
        catch (ParserConfigurationException e) {
            throw new TransformerException(this.getI18NMessages().payloadNotXmlSource(), (Transformer)this);
        }
        catch (SAXException e) {
            throw new TransformerException(this.getI18NMessages().payloadNotXmlSource(), (Transformer)this);
        }
        catch (IOException e) {
            throw new TransformerException(this.getI18NMessages().payloadNotXmlSource(), (Transformer)this);
        }
    }

    public Source getXmlFragmentFromHolder(Document holderDoc, String partID) throws TransformerException {
        NodeList nodeList = holderDoc.getElementsByTagName(partID);
        if (nodeList.getLength() > 0) {
            return new DOMSource(nodeList.item(0));
        }
        return new StreamSource(new StringReader(""));
    }

    private Object createHolder(Source xmlSource) throws HostTransformException {
        try {
            return this.mXmlUnmarshaller.unmarshal(xmlSource);
        }
        catch (JAXBException e) {
            throw new HostTransformException(e);
        }
    }
}

