/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport.legstar.transformer;

import com.legstar.coxb.transform.AbstractTransformers;
import com.legstar.coxb.transform.HostTransformException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.mule.api.MuleMessage;
import org.mule.api.transformer.Transformer;
import org.mule.api.transformer.TransformerException;
import org.mule.transformer.types.DataTypeFactory;
import org.mule.transport.legstar.transformer.AbstractHostJavaMuleTransformer;
import org.mule.transport.legstar.transformer.AbstractHostMuleTransformer;
import org.mule.transport.legstar.transformer.IObjectToHostTransformer;

public abstract class AbstractJavaToHostMuleTransformer
extends AbstractHostJavaMuleTransformer
implements IObjectToHostTransformer {
    private AbstractHostMuleTransformer.HolderGetter holderGetter;

    public AbstractJavaToHostMuleTransformer(AbstractTransformers bindingTransformers) {
        super(bindingTransformers);
        this.setReturnDataType(DataTypeFactory.BYTE_ARRAY);
    }

    public AbstractJavaToHostMuleTransformer(Map<String, AbstractTransformers> bindingTransformersMap) {
        super(bindingTransformersMap);
        this.setReturnDataType(DataTypeFactory.create(Map.class));
    }

    public AbstractJavaToHostMuleTransformer(List<AbstractTransformers> bindingTransformersList, AbstractHostMuleTransformer.HolderGetter holderGetter) {
        super(bindingTransformersList);
        this.setReturnDataType(DataTypeFactory.BYTE_ARRAY);
        this.holderGetter = holderGetter;
    }

    @Override
    public Object hostTransform(MuleMessage esbMessage, String encoding) throws TransformerException {
        try {
            String hostCharset = this.getHostCharset(esbMessage);
            if (this.getBindingTransformers() != null) {
                byte[] hostData = this.getBindingTransformers().toHost(esbMessage.getPayload(), hostCharset);
                return hostData;
            }
            if (this.getBindingTransformersList() != null) {
                Object holder = esbMessage.getPayload();
                int index = 0;
                int hostDataSize = 0;
                byte[][] hostBytesArray = new byte[this.getBindingTransformersList().size()][];
                for (AbstractTransformers xf : this.getBindingTransformersList()) {
                    hostBytesArray[index] = xf.toHost(this.holderGetter.get(holder, index), hostCharset);
                    hostDataSize += hostBytesArray[index].length;
                    ++index;
                }
                byte[] hostData = new byte[hostDataSize];
                int requestBytePos = 0;
                for (int i = 0; i < hostBytesArray.length; ++i) {
                    System.arraycopy(hostBytesArray[i], 0, hostData, requestBytePos, hostBytesArray[i].length);
                    requestBytePos += hostBytesArray[i].length;
                }
                return hostData;
            }
            if (this.getBindingTransformersMap() != null) {
                HashMap<String, byte[]> hostDataMap = new HashMap<String, byte[]>();
                for (Map.Entry<String, AbstractTransformers> entry : this.getBindingTransformersMap().entrySet()) {
                    Object valueObject = this.getObjectFromHolder(esbMessage.getPayload(), entry.getKey());
                    hostDataMap.put(entry.getKey(), entry.getValue().toHost(valueObject, hostCharset));
                }
                return hostDataMap;
            }
            return null;
        }
        catch (HostTransformException e) {
            throw new TransformerException(this.getI18NMessages().hostTransformFailure(), (Transformer)this, (Throwable)e);
        }
    }

    public Object getObjectFromHolder(Object holderObject, String partID) throws TransformerException {
        throw new TransformerException(this.getI18NMessages().noMultiPartSupportFailure(), (Transformer)this);
    }
}

