/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport.legstar.transformer;

import com.legstar.coxb.host.HostContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.api.MuleMessage;
import org.mule.api.transformer.Transformer;
import org.mule.api.transformer.TransformerException;
import org.mule.transformer.AbstractMessageTransformer;
import org.mule.transport.legstar.i18n.LegstarMessages;
import org.mule.util.ClassUtils;

public abstract class AbstractHostMuleTransformer
extends AbstractMessageTransformer {
    private String _hostCharset = HostContext.getDefaultHostCharsetName();
    private final LegstarMessages mI18NMessages = new LegstarMessages();
    private final Log _log = LogFactory.getLog(((Object)((Object)this)).getClass());

    public Object transformMessage(MuleMessage esbMessage, String encoding) throws TransformerException {
        if (this._log.isDebugEnabled()) {
            this._log.debug("Transform for message id: " + esbMessage.getUniqueId() + " source object is: " + ClassUtils.getSimpleName(esbMessage.getPayload().getClass()));
        }
        if (esbMessage.getExceptionPayload() != null) {
            throw new TransformerException(this.getI18NMessages().hostTransformFailure(), (Transformer)this, esbMessage.getExceptionPayload().getException());
        }
        Object result = this.hostTransform(esbMessage, encoding);
        if (this._log.isDebugEnabled()) {
            this._log.debug("Resulting object is " + ClassUtils.getSimpleName(result.getClass()));
        }
        return result;
    }

    public abstract Object hostTransform(MuleMessage var1, String var2) throws TransformerException;

    public String getHostCharset(MuleMessage message) {
        return (String)message.getInboundProperty("hostCharset", (Object)this.getHostCharset());
    }

    public String getHostCharset() {
        return this._hostCharset;
    }

    public void setHostCharset(String charset) {
        this._hostCharset = charset;
    }

    public LegstarMessages getI18NMessages() {
        return this.mI18NMessages;
    }

    public static interface HolderGetter {
        public Object get(Object var1, int var2);

        public Class<?> getHolderType();
    }

    public static interface HolderSetter {
        public void set(Object var1, int var2);

        public Object getHolder();

        public Class<?> getHolderType();
    }
}

