/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport.legstar.tcp;

import com.legstar.csok.client.CicsSocket;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.net.Socket;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.api.security.Credentials;
import org.mule.transport.legstar.tcp.LegstarTcpConnector;
import org.mule.transport.legstar.tcp.LegstarTcpSocketKey;
import org.mule.transport.legstar.tcp.i18n.LegstarTcpMessages;
import org.mule.transport.tcp.TcpSocketFactory;

public class LegstarTcpSocketFactory
extends TcpSocketFactory {
    public static final String REPLY_ACK_MSG_EC = "LSOKACK0";
    public static final int MAX_PROT_REPLY_LEN = 266;
    public static final String UOW_COMMIT = "Commit";
    public static final String UOW_ROLLBACK = "Rollback";
    public static final String UOW_KEEP = "Keep";
    private LegstarTcpConnector _connector;
    private static final LegstarTcpMessages I18N = new LegstarTcpMessages();
    private static final Log LOG = LogFactory.getLog(LegstarTcpSocketFactory.class);

    public LegstarTcpSocketFactory(LegstarTcpConnector connector) {
        this._connector = connector;
    }

    public Object makeObject(Object key) throws Exception {
        if (LOG.isDebugEnabled()) {
            LOG.debug("No sockets available from pool. Requested to create a new one.");
        }
        Socket socket = (Socket)super.makeObject(key);
        LegstarTcpSocketKey socketKey = (LegstarTcpSocketKey)((Object)key);
        this.exchangeInitialMessage(socket, socketKey.getCredentials());
        return socket;
    }

    public boolean validateObject(Object key, Object object) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Requested to validate a socket.");
        }
        boolean valid = super.validateObject(key, object);
        if (this.getConnector().isKeepSendSocketOpen()) {
            try {
                this.exchangeProbeMessage((Socket)object);
            }
            catch (Exception e) {
                valid = false;
            }
        }
        return valid;
    }

    public void passivateObject(Object key, Object object) throws Exception {
        super.passivateObject(key, object);
        Socket socket = (Socket)object;
        if (!socket.isClosed()) {
            this.exchangeCommitMessage((Socket)object);
        }
    }

    protected void exchangeInitialMessage(Socket socket, Credentials credentials) throws Exception {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Sending initial message to socket server.");
        }
        this.write(socket, CicsSocket.formatCIM(credentials.getUsername(), new String(credentials.getPassword()), "muleSocket", LOG.isDebugEnabled(), "IBM1047"));
        this.receiveAck(socket);
    }

    protected void exchangeProbeMessage(Socket socket) throws Exception {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Sending probe message to socket server.");
        }
        this.write(socket, CicsSocket.formatProbe("IBM1047"));
        this.receiveAck(socket);
    }

    protected void exchangeCommitMessage(Socket socket) throws Exception {
        this.exchangeUOWMessage(socket, UOW_COMMIT);
    }

    private void exchangeUOWMessage(Socket socket, String command) throws Exception {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Sending " + command + " unit of work command to socket server.");
        }
        this.write(socket, CicsSocket.formatUOW(command, "IBM1047"));
        this.receiveAck(socket);
    }

    private void receiveAck(Socket socket) throws IOException {
        byte[] response = this.read(socket, 266);
        if (response == null) {
            throw new IOException(I18N.noResponseFromHostMessage().getMessage());
        }
        String ackString = new String(response, "IBM1047").trim();
        if (LOG.isDebugEnabled()) {
            LOG.debug("Socket server reply is: " + ackString);
        }
        if (REPLY_ACK_MSG_EC.compareTo(ackString.substring(0, REPLY_ACK_MSG_EC.length())) != 0) {
            if (Character.getType(ackString.charAt(0)) == 1) {
                throw new IOException(ackString);
            }
            throw new IOException(I18N.unrecognizedResponseFromHostMessage().getMessage());
        }
    }

    private void write(Socket socket, byte[] data) throws IOException {
        BufferedOutputStream bos = new BufferedOutputStream(socket.getOutputStream());
        bos.write(data);
        bos.flush();
    }

    private byte[] read(Socket socket, int maxLength) throws IOException {
        byte[] buffer;
        BufferedInputStream bis = new BufferedInputStream(socket.getInputStream());
        int rc = bis.read(buffer = new byte[maxLength], 0, maxLength);
        if (rc == -1) {
            return null;
        }
        return buffer;
    }

    public LegstarTcpConnector getConnector() {
        return this._connector;
    }
}

