/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport.legstar.tcp;

import com.legstar.csok.client.CicsSocket;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.mule.transport.legstar.tcp.i18n.LegstarTcpMessages;
import org.mule.transport.tcp.protocols.DirectProtocol;

public class LegstarTcpProtocol
extends DirectProtocol {
    public static final String EXEC_REQUEST_EC = "LSOKEXEC";
    public static final int REPLY_HDR_LEN = 9;
    public static final String DATA_MSG_EC = "LSOKDATA";
    public static final String REPLY_ERROR_MSG_EC = "LSOKERR0";
    public static final int MAX_PROT_REPLY_LEN = 266;
    private static final LegstarTcpMessages I18N = new LegstarTcpMessages();

    protected void writeByteArray(OutputStream os, byte[] data) throws IOException {
        BufferedOutputStream bos = new BufferedOutputStream(os);
        bos.write(CicsSocket.formatMessageType(EXEC_REQUEST_EC, "IBM1047"));
        bos.write(data);
        bos.flush();
    }

    public Object read(InputStream is) throws IOException {
        String msgType = this.recvMessageType(is);
        if (DATA_MSG_EC.compareTo(msgType.substring(0, DATA_MSG_EC.length())) != 0) {
            this.recvError(msgType, is);
        }
        return super.read(is);
    }

    private String recvMessageType(InputStream is) throws IOException {
        String msgType = this.getCharsFromHost(is, 9);
        if (msgType == null) {
            throw new IOException(I18N.noResponseFromHostMessage().getMessage());
        }
        if (msgType.length() < 9) {
            throw new IOException(I18N.invalidReplyFromHostMessage().getMessage());
        }
        return msgType;
    }

    private void recvError(String msgType, InputStream is) throws IOException {
        if (REPLY_ERROR_MSG_EC.compareTo(msgType.substring(0, REPLY_ERROR_MSG_EC.length())) != 0) {
            String errString = this.getCharsFromHost(is, 266);
            throw new IOException(msgType + errString);
        }
        String errString = this.getCharsFromHost(is, 266);
        throw new IOException(errString.trim());
    }

    private String getCharsFromHost(InputStream is, int maxSize) throws IOException {
        byte[] buffer = (byte[])super.read(is, maxSize);
        if (buffer == null) {
            return null;
        }
        return new String(buffer, "IBM1047");
    }
}

