/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport.legstar.tcp;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.net.SocketTimeoutException;
import org.mule.api.MuleEvent;
import org.mule.api.MuleMessage;
import org.mule.api.endpoint.ImmutableEndpoint;
import org.mule.api.endpoint.OutboundEndpoint;
import org.mule.api.processor.MessageProcessor;
import org.mule.api.retry.RetryContext;
import org.mule.api.transport.DispatchException;
import org.mule.transport.DefaultMuleMessageFactory;
import org.mule.transport.legstar.i18n.LegstarMessages;
import org.mule.transport.legstar.tcp.LegstarTcpConnector;
import org.mule.transport.tcp.TcpInputStream;
import org.mule.transport.tcp.TcpMessageDispatcher;

public class LegstarTcpMessageDispatcher
extends TcpMessageDispatcher {
    private static final LegstarMessages I18N_COMMON = new LegstarMessages();

    public LegstarTcpMessageDispatcher(OutboundEndpoint endpoint) {
        super(endpoint);
    }

    public void doDispatch(MuleEvent event) throws Exception {
        throw new UnsupportedOperationException("doDispatch");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized MuleMessage doSend(MuleEvent event) throws Exception {
        MuleMessage requestMuleMessage = event.getMessage();
        Object body = requestMuleMessage.getPayload();
        if (body instanceof byte[]) {
            Socket socket = this.getConnector().getSocket(event, (ImmutableEndpoint)this.getEndpoint());
            this.dispatchToSocket(socket, event);
            try {
                if (this.returnResponse(event, true)) {
                    Object legstarReplyMessage;
                    block13: {
                        try {
                            legstarReplyMessage = this.receiveFromSocket(socket, event);
                            if (legstarReplyMessage != null) break block13;
                            MuleMessage muleMessage = null;
                            return muleMessage;
                        }
                        catch (SocketTimeoutException e) {
                            this.logger.info("Socket timed out normally while doing a synchronous receive on endpointUri: " + this.getEndpoint().getEndpointURI());
                            MuleMessage muleMessage = null;
                            return muleMessage;
                        }
                    }
                    if (legstarReplyMessage instanceof MuleMessage) {
                        MuleMessage muleMessage = (MuleMessage)legstarReplyMessage;
                        return muleMessage;
                    }
                    DefaultMuleMessageFactory messageFactory = new DefaultMuleMessageFactory(this.getConnector().getMuleContext());
                    MuleMessage muleMessage = messageFactory.create(legstarReplyMessage, this.getEndpoint().getEncoding());
                    return muleMessage;
                }
                MuleMessage muleMessage = null;
                return muleMessage;
            }
            finally {
                if (!this.returnResponse(event, true)) {
                    this.getConnector().releaseSocket(socket, event, (ImmutableEndpoint)this.getEndpoint());
                }
            }
        }
        throw new DispatchException(I18N_COMMON.invalidBodyMessage(), event, (MessageProcessor)this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object receiveFromSocket(final Socket socket, final MuleEvent event) throws IOException {
        int timeout = event.getTimeout();
        final LegstarTcpConnector connector = (LegstarTcpConnector)this.getEndpoint().getConnector();
        DataInputStream underlyingIs = new DataInputStream(new BufferedInputStream(socket.getInputStream()));
        TcpInputStream tis = new TcpInputStream(underlyingIs){

            public void close() throws IOException {
                try {
                    connector.releaseSocket(socket, event, (ImmutableEndpoint)LegstarTcpMessageDispatcher.this.getEndpoint());
                }
                catch (IOException e) {
                    throw e;
                }
                catch (Exception e) {
                    IOException e2 = new IOException();
                    e2.initCause(e);
                    throw e2;
                }
            }
        };
        if (timeout >= 0) {
            socket.setSoTimeout(timeout);
        }
        try {
            Object object = connector.getTcpProtocol().read((InputStream)tis);
            return object;
        }
        finally {
            if (!tis.isStreaming()) {
                tis.close();
            }
        }
    }

    private void dispatchToSocket(Socket socket, MuleEvent event) throws Exception {
        Object payload = event.getMessage().getPayload();
        this.write(socket, payload);
    }

    private void write(Socket socket, Object data) throws IOException {
        BufferedOutputStream bos = new BufferedOutputStream(socket.getOutputStream());
        this.getConnector().getTcpProtocol().write((OutputStream)bos, data);
        bos.flush();
    }

    public RetryContext validateConnection(RetryContext retryContext) {
        retryContext.setOk();
        return retryContext;
    }

    public LegstarTcpConnector getConnector() {
        return (LegstarTcpConnector)super.getConnector();
    }
}

