/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport.legstar.mock;

import com.legstar.messaging.LegStarConnection;
import com.legstar.messaging.LegStarMessage;
import com.legstar.messaging.LegStarRequest;
import com.legstar.mock.client.MockConnectionFactory;
import org.mule.api.MuleEvent;
import org.mule.api.MuleMessage;
import org.mule.api.endpoint.OutboundEndpoint;
import org.mule.api.processor.MessageProcessor;
import org.mule.api.transport.DispatchException;
import org.mule.transport.AbstractMessageDispatcher;
import org.mule.transport.DefaultMuleMessageFactory;
import org.mule.transport.legstar.i18n.LegstarMessages;

public class LegstarMockMessageDispatcher
extends AbstractMessageDispatcher {
    private LegStarConnection _mockConnection;
    private static final LegstarMessages I18N_COMMON = new LegstarMessages();

    public LegstarMockMessageDispatcher(OutboundEndpoint endpoint) {
        super(endpoint);
    }

    public void doConnect() throws Exception {
        MockConnectionFactory mockConnectionFactory = new MockConnectionFactory();
        this._mockConnection = mockConnectionFactory.createConnection("connectionID", null, null);
    }

    public void doDisconnect() throws Exception {
    }

    public void doDispatch(MuleEvent event) throws Exception {
        throw new UnsupportedOperationException("doDispatch");
    }

    public MuleMessage doSend(MuleEvent event) throws Exception {
        MuleMessage requestMuleMessage = event.getMessage();
        Object body = requestMuleMessage.getPayload();
        if (body instanceof byte[]) {
            LegStarMessage legstarRequestMessage = new LegStarMessage();
            legstarRequestMessage.fromByteArray((byte[])body, 0);
            LegStarRequest legStarRequest = new LegStarRequest(requestMuleMessage.getCorrelationId(), null, legstarRequestMessage);
            this.getMockConnection().recvResponse(legStarRequest);
            LegStarMessage legstarReplyMessage = legStarRequest.getResponseMessage();
            DefaultMuleMessageFactory messageFactory = new DefaultMuleMessageFactory(this.getConnector().getMuleContext());
            return messageFactory.create((Object)legstarReplyMessage.toByteArray(), this.getEndpoint().getEncoding());
        }
        throw new DispatchException(I18N_COMMON.invalidBodyMessage(), event, (MessageProcessor)this);
    }

    public void doDispose() {
    }

    public LegStarConnection getMockConnection() {
        return this._mockConnection;
    }
}

