/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport.legstar.config;

import java.util.ArrayList;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONStringer;
import org.mule.transport.legstar.config.HostContainer;

public class HostProgram {
    private String _name;
    private int _maxDataLength;
    private int _dataLength;
    private String _sysID;
    private boolean _syncOnReturn;
    private String _transID;
    private String _channelName;
    private List<HostContainer> _inputContainer = new ArrayList<HostContainer>();
    private List<HostContainer> _outputContainers = new ArrayList<HostContainer>();

    public int getMaxDataLength() {
        return this._maxDataLength;
    }

    public void setMaxDataLength(int maxDataLength) {
        this._maxDataLength = maxDataLength;
    }

    public String getChannelName() {
        return this._channelName;
    }

    public void setChannelName(String name) {
        this._channelName = name;
    }

    public void addInputContainer(HostContainer container) {
        this._inputContainer.add(container);
    }

    public List<HostContainer> getInputContainers() {
        return this._inputContainer;
    }

    public void setInputContainers(List<HostContainer> containers) {
        this._inputContainer = containers;
    }

    public void addOutputContainer(HostContainer container) {
        this._outputContainers.add(container);
    }

    public List<HostContainer> getOutputContainers() {
        return this._outputContainers;
    }

    public void setOutputContainers(List<HostContainer> containers) {
        this._outputContainers = containers;
    }

    public int getDataLength() {
        return this._dataLength;
    }

    public void setDataLength(int dataLength) {
        this._dataLength = dataLength;
    }

    public String getName() {
        return this._name;
    }

    public void setName(String name) {
        this._name = name;
    }

    public String getProgramName() {
        return this._name;
    }

    public void setProgramName(String name) {
        this._name = name;
    }

    public boolean isSyncOnReturn() {
        return this._syncOnReturn;
    }

    public void setSyncOnReturn(boolean syncOnReturn) {
        this._syncOnReturn = syncOnReturn;
    }

    public String getSysID() {
        return this._sysID;
    }

    public void setSysID(String sysID) {
        this._sysID = sysID;
    }

    public String getTransID() {
        return this._transID;
    }

    public void setTransID(String transID) {
        this._transID = transID;
    }

    public String toJSONHost() throws JSONException {
        JSONStringer stringer = new JSONStringer();
        stringer.object();
        stringer.key("CICSProgramName");
        stringer.value(this.getName());
        if (this.hasChannel()) {
            stringer.key("CICSChannel");
            stringer.value(this.getChannelName());
            if (this.getOutputContainers() != null && this.getOutputContainers().size() > 0) {
                stringer.key("CICSOutContainers");
                stringer.value(this.toJSONNames(this.getOutputContainers()));
            }
        } else {
            stringer.key("CICSLength");
            stringer.value(Integer.toString(this.getMaxDataLength()));
            stringer.key("CICSDataLength");
            stringer.value(Integer.toString(this.getDataLength()));
        }
        if (this.getSysID() != null) {
            stringer.key("CICSSysID");
            stringer.value(this.getSysID());
        }
        if (this.isSyncOnReturn()) {
            stringer.key("CICSSyncOnReturn");
            stringer.value("1");
        }
        if (this.getTransID() != null) {
            stringer.key("CICSTransID");
            stringer.value(this.getTransID());
        }
        stringer.endObject();
        return stringer.toString();
    }

    public boolean hasChannel() {
        return this.getChannelName() != null && this.getChannelName().length() > 0;
    }

    private JSONArray toJSONNames(List<HostContainer> containers) throws JSONException {
        JSONArray jContainers = new JSONArray();
        for (HostContainer container : containers) {
            jContainers.put(container.getName());
        }
        return jContainers;
    }
}

