/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport.legstar.cixs.transformer;

import java.util.Map;
import org.mule.api.MuleMessage;
import org.mule.api.transformer.TransformerException;
import org.mule.transformer.types.DataTypeFactory;
import org.mule.transport.legstar.config.HostProgram;
import org.mule.transport.legstar.transformer.AbstractHostMuleTransformer;

public abstract class AbstractHostToExecRequestMuleTransformer
extends AbstractHostMuleTransformer {
    private HostProgram _hostProgram;
    private String _replyTo;
    private boolean _hostTraceOn = false;
    public static final String LEGSTAR_HOST_TRACE_ON_KEY = "LEGSTAR_HOST_TRACE_ON";
    private static final int WMQ_ID_LEN = 24;
    private static final String WMQ_JMS_ID_PREFIX = "ID:";

    public AbstractHostToExecRequestMuleTransformer() {
        this.registerSourceType(DataTypeFactory.create(Map.class));
        this.registerSourceType(DataTypeFactory.BYTE_ARRAY);
        this.setReturnDataType(DataTypeFactory.BYTE_ARRAY);
    }

    @Override
    public Object hostTransform(MuleMessage esbMessage, String outputEncoding) throws TransformerException {
        Object src = esbMessage.getPayload();
        byte[] wrappedHostData = null;
        if (src instanceof byte[]) {
            wrappedHostData = this.wrapHostData((byte[])src, esbMessage);
        } else if (src instanceof Map) {
            wrappedHostData = this.wrapHostData((Map)src, esbMessage);
        }
        esbMessage.setReplyTo((Object)this.getReplyTo());
        boolean isHostTraceOn = (Boolean)esbMessage.getInboundProperty(LEGSTAR_HOST_TRACE_ON_KEY, (Object)this.isHostTraceOn());
        esbMessage.setOutboundProperty(LEGSTAR_HOST_TRACE_ON_KEY, (Object)isHostTraceOn);
        this.setMessageProperties(esbMessage);
        return wrappedHostData;
    }

    public abstract byte[] wrapHostData(byte[] var1, MuleMessage var2) throws TransformerException;

    public abstract byte[] wrapHostData(Map<String, byte[]> var1, MuleMessage var2) throws TransformerException;

    public abstract void setMessageProperties(MuleMessage var1);

    public String getHostCompatibleCorrelationId(String id) {
        if (id == null) {
            return null;
        }
        char[] chars = id.toCharArray();
        StringBuffer output = new StringBuffer();
        output.append(WMQ_JMS_ID_PREFIX);
        for (int i = 0; i < chars.length && i < 24; ++i) {
            output.append(Integer.toHexString(chars[i]));
        }
        return output.toString();
    }

    public HostProgram getHostProgram() {
        return this._hostProgram;
    }

    public void setHostProgram(HostProgram hostProgram) {
        this._hostProgram = hostProgram;
    }

    public String getReplyTo() {
        return this._replyTo;
    }

    public void setReplyTo(String to) {
        this._replyTo = to;
    }

    public boolean isHostTraceOn() {
        return this._hostTraceOn;
    }

    public void setHostTraceOn(boolean traceOn) {
        this._hostTraceOn = traceOn;
    }
}

