/*
 * Decompiled with CFR 0.152.
 */
package com.legstar.work.manager;

import com.legstar.work.manager.WorkEventImpl;
import com.legstar.work.manager.WorkItemImpl;
import commonj.work.Work;
import commonj.work.WorkException;
import commonj.work.WorkItem;
import commonj.work.WorkListener;
import commonj.work.WorkManager;
import java.util.Collection;
import java.util.UUID;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.RejectedExecutionException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class WorkManagerImpl
implements WorkManager {
    private ExecutorService mExecutor;
    private final Log _log = LogFactory.getLog(WorkManagerImpl.class);

    public WorkManagerImpl(ExecutorService executor) {
        this.mExecutor = executor;
    }

    public WorkItem schedule(Work work) {
        return this.schedule(work, null);
    }

    public WorkItem schedule(Work work, WorkListener workListener) {
        WorkItemImpl workItem = new WorkItemImpl(UUID.randomUUID().toString(), work);
        if (this._log.isDebugEnabled()) {
            this._log.debug("Scheduling new work item " + workItem.getId());
        }
        try {
            this.mExecutor.execute(new DecoratingWork(workItem, work, workListener));
            this.workAccepted(workItem, workListener);
        }
        catch (RejectedExecutionException e) {
            workItem.setException(new WorkException(e));
            this.workRejected(workItem, workListener);
        }
        return workItem;
    }

    public boolean waitForAll(Collection works, long timeout) {
        throw new UnsupportedOperationException("waitForAll not supported");
    }

    public Collection waitForAny(Collection works, long timeout) {
        throw new UnsupportedOperationException("waitForAny not supported");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void workAccepted(WorkItemImpl workItem, WorkListener workListener) {
        WorkItemImpl workItemImpl = workItem;
        synchronized (workItemImpl) {
            if (this._log.isDebugEnabled()) {
                this._log.debug("Work item " + workItem.getId() + " accepted");
            }
            workItem.setStatus(1);
            if (workListener != null) {
                WorkEventImpl event = new WorkEventImpl(workItem);
                workListener.workAccepted(event);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void workRejected(WorkItemImpl workItem, WorkListener workListener) {
        WorkItemImpl workItemImpl = workItem;
        synchronized (workItemImpl) {
            if (this._log.isDebugEnabled()) {
                this._log.debug("Work item " + workItem.getId() + " rejected");
            }
            workItem.setStatus(2);
            if (workListener != null) {
                workListener.workRejected(new WorkEventImpl(workItem));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void workStarted(WorkItemImpl workItem, DecoratingWork decoratingWork) {
        WorkItemImpl workItemImpl = workItem;
        synchronized (workItemImpl) {
            if (this._log.isDebugEnabled()) {
                this._log.debug("Work item " + workItem.getId() + " started");
            }
            workItem.setStatus(3);
            WorkListener workListener = decoratingWork.getWorkListener();
            if (workListener != null) {
                WorkEventImpl event = new WorkEventImpl(workItem);
                workListener.workStarted(event);
            }
        }
    }

    private void workCompleted(WorkItemImpl workItem, DecoratingWork decoratingWork) {
        this.workCompleted(workItem, decoratingWork, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void workCompleted(WorkItemImpl workItem, DecoratingWork decoratingWork, WorkException exception) {
        WorkItemImpl workItemImpl = workItem;
        synchronized (workItemImpl) {
            WorkListener workListener;
            if (this._log.isDebugEnabled()) {
                this._log.debug("Work item " + workItem.getId() + " completed");
            }
            workItem.setStatus(4);
            workItem.setResult(decoratingWork.getDecoratedWork());
            workItem.setException(exception);
            if (this._log.isDebugEnabled()) {
                this._log.debug("Work item " + workItem.getId() + " updated with results");
            }
            if ((workListener = decoratingWork.getWorkListener()) != null) {
                WorkEventImpl event = new WorkEventImpl(workItem);
                workListener.workCompleted(event);
            }
        }
    }

    private final class DecoratingWork
    implements Runnable {
        private WorkItemImpl mWorkItem;
        private Work mDecoratedWork;
        private WorkListener mWorkListener;

        public DecoratingWork(WorkItemImpl workItem, Work decoratedWork, WorkListener workListener) {
            this.mWorkItem = workItem;
            this.mDecoratedWork = decoratedWork;
            this.mWorkListener = workListener;
        }

        public void run() {
            WorkManagerImpl.this.workStarted(this.mWorkItem, this);
            try {
                this.mDecoratedWork.run();
                WorkManagerImpl.this.workCompleted(this.mWorkItem, this);
            }
            catch (Throwable th) {
                WorkManagerImpl.this._log.error("Work item: " + this.mWorkItem.getId() + " failed", th);
                WorkManagerImpl.this.workCompleted(this.mWorkItem, this, new WorkException(th.getMessage(), th));
            }
        }

        public WorkListener getWorkListener() {
            return this.mWorkListener;
        }

        public Work getDecoratedWork() {
            return this.mDecoratedWork;
        }
    }
}

