/*
 * Decompiled with CFR 0.152.
 */
package com.legstar.work.invoke;

import com.legstar.messaging.LegStarConnection;
import com.legstar.messaging.LegStarRequest;
import com.legstar.pool.manager.ConnectionPool;
import com.legstar.pool.manager.ConnectionPoolException;
import commonj.work.WorkEvent;
import commonj.work.WorkListener;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class InvokeWorkListener
implements WorkListener {
    private ConnectionPool mConnectionPool;
    private LegStarConnection mConnection;
    private LegStarRequest mRequest;
    private final Log _log = LogFactory.getLog(this.getClass());

    public InvokeWorkListener(LegStarRequest request, LegStarConnection connection, ConnectionPool connectionPool) {
        this.mConnectionPool = connectionPool;
        this.mConnection = connection;
        this.mRequest = request;
    }

    public void workAccepted(WorkEvent workEvent) {
        if (this._log.isDebugEnabled()) {
            this._log.debug("Work accepted for Request:" + this.mRequest.getID() + " on Connection:" + this.mConnection.getConnectionID());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void workCompleted(WorkEvent workEvent) {
        LegStarRequest legStarRequest = this.mRequest;
        synchronized (legStarRequest) {
            try {
                this.mConnectionPool.put(this.mConnection);
            }
            catch (ConnectionPoolException e) {
                this.mRequest.setException(e);
            }
            if (this._log.isDebugEnabled()) {
                if (workEvent.getException() != null) {
                    this._log.debug("Work failed for Request:" + this.mRequest.getID() + " on Connection:" + this.mConnection.getConnectionID(), workEvent.getException());
                } else {
                    this._log.debug("Work completed for Request:" + this.mRequest.getID() + " on Connection:" + this.mConnection.getConnectionID());
                }
            }
            this.mRequest.signalProcessingStop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void workRejected(WorkEvent workEvent) {
        LegStarRequest legStarRequest = this.mRequest;
        synchronized (legStarRequest) {
            try {
                this.mConnectionPool.put(this.mConnection);
            }
            catch (ConnectionPoolException e) {
                this.mRequest.setException(e);
            }
            if (this._log.isDebugEnabled()) {
                this._log.debug("Work rejected for Request:" + this.mRequest.getID() + " on Connection:" + this.mConnection.getConnectionID());
            }
            this.mRequest.signalProcessingStop();
        }
    }

    public void workStarted(WorkEvent workEvent) {
        if (this._log.isDebugEnabled()) {
            this._log.debug("Work started for Request:" + this.mRequest.getID() + " on Connection:" + this.mConnection.getConnectionID());
        }
    }
}

