/*
 * Decompiled with CFR 0.152.
 */
package com.legstar.work.invoke;

import com.legstar.messaging.ConnectionException;
import com.legstar.messaging.LegStarConnection;
import com.legstar.messaging.LegStarRequest;
import com.legstar.messaging.RequestException;
import commonj.work.Work;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class InvokeWork
implements Work {
    private final Log _log = LogFactory.getLog(InvokeWork.class);
    private LegStarConnection mConnection;
    private LegStarRequest mRequest;

    public InvokeWork(LegStarRequest request, LegStarConnection connection) {
        this.mRequest = request;
        this.mConnection = connection;
    }

    public boolean isDaemon() {
        return false;
    }

    public void release() {
    }

    public void run() {
        long startTime = System.currentTimeMillis();
        this._log.debug("Unit of Work started for Request:" + this.mRequest.getID());
        try {
            this._log.debug("Connecting to host for Request:" + this.mRequest.getID() + " on Connection:" + this.mConnection.getConnectionID());
            this.mConnection.connectReuse(this.mRequest.getAddress().getHostPassword());
            this.mConnection.sendRequest(this.mRequest);
            this.mConnection.recvResponse(this.mRequest);
            this.mConnection.commitUOW();
        }
        catch (ConnectionException e) {
            this.mRequest.setException(e);
            throw new RuntimeException(e);
        }
        catch (RequestException e) {
            this.mRequest.setException(e);
            throw new RuntimeException(e);
        }
        long endTime = System.currentTimeMillis();
        this._log.debug("Request:" + this.mRequest.getID() + " on Connection:" + this.mConnection.getConnectionID() + " serviced in " + (endTime - startTime) + " msecs");
    }

    public LegStarConnection getConnection() {
        return this.mConnection;
    }

    public void setConnection(LegStarConnection connection) {
        this.mConnection = connection;
    }

    public LegStarRequest getRequest() {
        return this.mRequest;
    }

    public void setRequest(LegStarRequest request) {
        this.mRequest = request;
    }
}

