/*
 * Decompiled with CFR 0.152.
 */
package com.legstar.pool.manager;

import com.legstar.pool.manager.ConnectionPool;
import com.legstar.pool.manager.ConnectionPoolException;
import java.util.Timer;
import java.util.TimerTask;

public class TimerIdleConnectionsPolicy {
    private Timer _timer;
    private CheckIdleConnectionsTask _timerTask;
    private static final String TIMER_THREAD_NAME = "LegstarIdleConnectionsTimer";

    public TimerIdleConnectionsPolicy(ConnectionPool connectionPool, long period, long maxIdleTime) {
        if (period > 0L && maxIdleTime > 0L) {
            this._timer = new Timer(TIMER_THREAD_NAME, true);
            this._timerTask = new CheckIdleConnectionsTask(connectionPool, maxIdleTime);
            this._timer.schedule((TimerTask)this._timerTask, period, period);
        }
    }

    public synchronized void stop() {
        if (this._timer != null) {
            this._timer.cancel();
            this._timer.purge();
            this._timer = null;
        }
    }

    public Throwable getException() {
        if (this._timerTask != null) {
            return this._timerTask.getException();
        }
        return null;
    }

    public Timer getTimer() {
        return this._timer;
    }

    private static class CheckIdleConnectionsTask
    extends TimerTask {
        private ConnectionPool _connectionPool;
        private long _maxIdleTime;
        private Throwable _exception;

        public CheckIdleConnectionsTask(ConnectionPool connectionPool, long maxIdleTime) {
            this._connectionPool = connectionPool;
            this._maxIdleTime = maxIdleTime;
        }

        public void run() {
            try {
                this._connectionPool.closeObsoleteConnections(this._maxIdleTime);
            }
            catch (ConnectionPoolException e) {
                this._exception = e;
                this.cancel();
            }
        }

        public Throwable getException() {
            return this._exception;
        }
    }
}

