/*
 * Decompiled with CFR 0.152.
 */
package com.legstar.pool.manager;

import com.legstar.messaging.HostEndpoint;
import com.legstar.messaging.LegStarAddress;
import com.legstar.pool.manager.ConnectionPool;
import com.legstar.pool.manager.ConnectionPoolException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConnectionPoolManager {
    private List<HostEndpoint> _hostEndpoints;
    private final Map<LegStarAddress, ConnectionPool> _pools;
    private final Log _log = LogFactory.getLog(this.getClass());

    public ConnectionPoolManager(List<HostEndpoint> hostEndpoints) {
        this._hostEndpoints = hostEndpoints;
        this._pools = new HashMap<LegStarAddress, ConnectionPool>();
        this._log.info("Pool Manager created.");
    }

    public ConnectionPool getPool(LegStarAddress address, boolean createIfNotFound) throws ConnectionPoolException {
        ConnectionPool pool;
        if (this._log.isDebugEnabled()) {
            this._log.debug("Retrieving pool for endpoint " + address.getEndPointName());
        }
        if ((pool = this._pools.get(address)) == null && createIfNotFound) {
            pool = this.createConnectionPool(address);
            this._pools.put(address, pool);
        }
        return pool;
    }

    protected ConnectionPool createConnectionPool(LegStarAddress address) throws ConnectionPoolException {
        if (this._log.isDebugEnabled()) {
            this._log.debug("Creating new pool for endpoint " + address.getEndPointName());
        }
        HostEndpoint hostEndpoint = this.getHostEndpoint(address);
        ConnectionPool connectionPool = new ConnectionPool(address, hostEndpoint);
        return connectionPool;
    }

    protected HostEndpoint getHostEndpoint(LegStarAddress address) throws ConnectionPoolException {
        if (this.getHostEndpoints().size() == 0) {
            throw new ConnectionPoolException("No host endpoints available.");
        }
        if (address == null || address.getEndPointName() == null || address.getEndPointName().length() == 0) {
            return this.getHostEndpoints().get(0);
        }
        for (HostEndpoint endpoint : this.getHostEndpoints()) {
            if (!address.getEndPointName().equals(endpoint.getName())) continue;
            return endpoint;
        }
        throw new ConnectionPoolException("No host endpoints matches " + address);
    }

    public void shutDown() {
        this._log.info("Shutting down Pool Manager");
        Iterator<Map.Entry<LegStarAddress, ConnectionPool>> entries = this._pools.entrySet().iterator();
        while (entries.hasNext()) {
            entries.next().getValue().shutDown();
        }
    }

    public Map<LegStarAddress, ConnectionPool> getPools() {
        return this._pools;
    }

    public List<HostEndpoint> getHostEndpoints() {
        return this._hostEndpoints;
    }
}

