/*
 * Decompiled with CFR 0.152.
 */
package com.legstar.pool.manager;

import com.legstar.messaging.ConnectionException;
import com.legstar.messaging.HostEndpoint;
import com.legstar.messaging.LegStarAddress;
import com.legstar.messaging.LegStarConnection;
import com.legstar.messaging.RequestException;
import com.legstar.pool.manager.BlockingStack;
import com.legstar.pool.manager.ConnectionPoolException;
import com.legstar.pool.manager.TimerIdleConnectionsPolicy;
import java.rmi.server.UID;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConnectionPool {
    private final Log _log = LogFactory.getLog(this.getClass());
    private HostEndpoint _hostEndpoint;
    private LegStarAddress _address;
    private BlockingStack<LegStarConnection> _connections;
    private boolean _shuttingDown;
    private TimerIdleConnectionsPolicy _idleConnectionsPolicy;

    public ConnectionPool(LegStarAddress address, HostEndpoint hostEndpoint) throws ConnectionPoolException {
        this._address = address;
        this._hostEndpoint = hostEndpoint;
        int poolSize = hostEndpoint.getHostConnectionPoolSize();
        this._connections = new BlockingStack(poolSize);
        try {
            for (int i = 0; i < poolSize; ++i) {
                this._connections.add(hostEndpoint.getHostConnectionfactory().createConnection(new UID().toString(), address, hostEndpoint));
            }
        }
        catch (ConnectionException e) {
            throw new ConnectionPoolException(e);
        }
        this._idleConnectionsPolicy = new TimerIdleConnectionsPolicy(this, hostEndpoint.getPooledMaxIdleTimeCheckPeriod(), hostEndpoint.getPooledMaxIdleTime());
        this._shuttingDown = false;
        this._log.info("Pool of size " + poolSize + ", created for endpoint: " + hostEndpoint.toString());
    }

    public LegStarConnection take(long timeout) throws ConnectionPoolException {
        LegStarConnection connection = null;
        if (!this._shuttingDown) {
            try {
                connection = this._connections.poll(timeout, TimeUnit.MILLISECONDS);
                if (connection == null) {
                    throw new ConnectionPoolException("Timed out waiting for pooled connection.");
                }
                return connection;
            }
            catch (InterruptedException e) {
                throw new ConnectionPoolException(e);
            }
        }
        throw new ConnectionPoolException("Pool is shutting down.");
    }

    public void put(LegStarConnection connection) throws ConnectionPoolException {
        if (!this._shuttingDown) {
            try {
                this._connections.add(connection);
            }
            catch (IllegalStateException e) {
                this._log.warn("Connection could not be recycled.");
            }
        } else {
            throw new ConnectionPoolException("Pool is shutting down.");
        }
    }

    public void shutDown() {
        this._log.info("Shutting down Pool " + this.getHostEndpoint().getName());
        this._shuttingDown = true;
        this._idleConnectionsPolicy.stop();
        if (this._connections.remainingCapacity() > 0) {
            if (this._connections.size() == 0) {
                this._log.warn("Some requests might be waiting for connections.");
            } else {
                this._log.warn("There are " + (this._connections.remainingCapacity() - this._connections.size()) + " connections in use.");
            }
        }
        for (LegStarConnection connection : this.getConnections()) {
            try {
                connection.close();
            }
            catch (RequestException e) {
                this._log.warn("Unable to close a connection " + e.toString());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void closeObsoleteConnections(long maxIdleTime) throws ConnectionPoolException {
        if (maxIdleTime < 0L) {
            return;
        }
        long now = System.currentTimeMillis();
        try {
            Iterator<LegStarConnection> iter = this._connections.iterator();
            while (iter.hasNext()) {
                LegStarConnection connection = iter.next();
                if (connection.getLastUsedTime() <= 0L || now - connection.getLastUsedTime() <= maxIdleTime) continue;
                if (this._log.isDebugEnabled()) {
                    this._log.debug("Closing obsolete Connection:" + connection.getConnectionID() + ". Has been opened for: " + (now - connection.getLastUsedTime()) + " ms");
                }
                this._connections.lock();
                try {
                    if (!this._connections.contains(connection)) continue;
                    connection.close();
                }
                finally {
                    this._connections.unlock();
                }
            }
        }
        catch (RequestException e) {
            throw new ConnectionPoolException(e);
        }
    }

    public List<LegStarConnection> getConnections() {
        return this._connections.getElementsList();
    }

    public HostEndpoint getHostEndpoint() {
        return this._hostEndpoint;
    }

    public LegStarAddress getAddress() {
        return this._address;
    }

    public TimerIdleConnectionsPolicy getIdleConnectionsPolicy() {
        return this._idleConnectionsPolicy;
    }
}

