/*
 * Decompiled with CFR 0.152.
 */
package com.legstar.pool.manager;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.NoSuchElementException;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantLock;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BlockingStack<T> {
    private int _capacity;
    private LinkedList<T> _list = new LinkedList();
    private final ReentrantLock _lock = new ReentrantLock();
    private LinkedList<ExchangeCountDownLatch<T>> _waiters = new LinkedList();

    public BlockingStack(int size) {
        this._capacity = size;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean add(T element) {
        if (this._list.size() == this._capacity) {
            throw new IllegalStateException("Stack is full.");
        }
        ReentrantLock lock = this._lock;
        lock.lock();
        ExchangeCountDownLatch<T> latch = null;
        try {
            if (this._waiters.size() > 0) {
                latch = this._waiters.removeFirst();
                latch.setItem(element);
            } else {
                this._list.addFirst(element);
            }
        }
        finally {
            lock.unlock();
        }
        if (latch != null) {
            latch.countDown();
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public T poll(long timeout, TimeUnit unit) throws InterruptedException {
        T result = null;
        ReentrantLock lock = this._lock;
        boolean error = true;
        lock.lock();
        try {
            if (this._list.size() == 0 && timeout > 0L) {
                ExchangeCountDownLatch latch = new ExchangeCountDownLatch(1);
                this._waiters.addLast(latch);
                lock.unlock();
                if (!latch.await(timeout, unit)) {
                    lock.lock();
                    this._waiters.remove(latch);
                    lock.unlock();
                }
                result = (T)latch.getItem();
            } else {
                result = this._list.removeFirst();
                lock.unlock();
            }
            error = false;
        }
        finally {
            if (error && lock.isHeldByCurrentThread()) {
                lock.unlock();
            }
        }
        return result;
    }

    public int remainingCapacity() {
        return this._capacity - this._list.size();
    }

    public int size() {
        return this._list.size();
    }

    public int getCapacity() {
        return this._capacity;
    }

    public LinkedList<T> getElementsList() {
        return this._list;
    }

    public Iterator<T> iterator() {
        return new FairIterator();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean contains(T element) {
        ReentrantLock lock = this._lock;
        lock.lock();
        try {
            boolean bl = this.getElementsList().contains(element);
            return bl;
        }
        finally {
            lock.unlock();
        }
    }

    public LinkedList<ExchangeCountDownLatch<T>> getWaiters() {
        return this._waiters;
    }

    public void lock() {
        ReentrantLock lock = this._lock;
        lock.lock();
    }

    public void unlock() {
        ReentrantLock lock = this._lock;
        lock.unlock();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class FairIterator
    implements Iterator<T> {
        private T[] elements = null;
        private int index;
        private T element = null;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public FairIterator() {
            ReentrantLock lock = BlockingStack.this._lock;
            lock.lock();
            try {
                this.elements = new Object[BlockingStack.this._list.size()];
                BlockingStack.this._list.toArray(this.elements);
                this.index = 0;
            }
            finally {
                lock.unlock();
            }
        }

        @Override
        public boolean hasNext() {
            return this.index < this.elements.length;
        }

        @Override
        public T next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            this.element = this.elements[this.index++];
            return this.element;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void remove() {
            ReentrantLock lock = BlockingStack.this._lock;
            lock.lock();
            try {
                if (this.element != null) {
                    BlockingStack.this._list.remove(this.element);
                }
            }
            finally {
                lock.unlock();
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class ExchangeCountDownLatch<E>
    extends CountDownLatch {
        protected volatile E _item;

        public ExchangeCountDownLatch(int i) {
            super(i);
        }

        public E getItem() {
            return this._item;
        }

        public void setItem(E item) {
            this._item = item;
        }
    }
}

