/*
 * Decompiled with CFR 0.152.
 */
package com.legstar.mq.client;

import com.legstar.coxb.transform.HostTransformException;
import com.legstar.messaging.CommareaPart;
import com.legstar.messaging.HeaderPartException;
import com.legstar.messaging.HostReceiveException;
import com.legstar.messaging.LegStarMessage;
import com.legstar.messaging.LegStarRequest;
import com.legstar.messaging.RequestException;
import com.legstar.mq.client.AbstractCicsMQ;
import com.legstar.mq.client.CicsMQConnectionException;
import com.legstar.mq.client.CicsMQEndpoint;
import com.legstar.mq.mqcih.Mqcih;
import com.legstar.mq.mqcih.bind.MqcihTransformers;
import java.io.IOException;
import javax.jms.BytesMessage;
import javax.jms.JMSException;
import javax.jms.Message;
import org.json.JSONException;
import org.json.JSONObject;

public class CicsMQMqcih
extends AbstractCicsMQ {
    private MqcihTransformers _MqcihTransformers = new MqcihTransformers();
    private static final int MQCIH_STRUCLENGTH = 180;
    private static final int MQCIH_REPLY_WITHOUT_NULLS = 2;
    private static final int CICS_PROGRAM_NAME_LEN = 8;
    public static final String MQFMT_NONE = "        ";
    public static final String MQFMT_CICS = "MQCICS  ";
    public static final String MQNEW_SESSION = "AMQ!NEW_SESSION_CORRELID";
    private static final int MQCIH_SYNC_ON_RETURN = 4;
    private static final int MQCUOWC_ONLY = 273;

    public CicsMQMqcih(String connectionID, CicsMQEndpoint cicsMQEndpoint) throws CicsMQConnectionException {
        super(connectionID, cicsMQEndpoint);
    }

    public Message createRequestMessage(LegStarRequest request) throws RequestException {
        if (request.getRequestMessage().getDataParts().size() > 1) {
            throw new RequestException("IBM CICS MQ Bridge does not support channel/containers");
        }
        String hostCharset = this.getHostCharset(request);
        byte[] hostData = new byte[]{};
        if (request.getRequestMessage().getDataParts().size() > 0) {
            hostData = request.getRequestMessage().getDataParts().get(0).getContent();
        }
        try {
            BytesMessage message = this.getJmsQueueSession().createBytesMessage();
            message.setJMSMessageID(null);
            message.setJMSCorrelationID(MQNEW_SESSION);
            message.setStringProperty("JMS_IBM_Format", MQFMT_CICS);
            message.setIntProperty("JMS_IBM_Character_Set", this.getCCSID(hostCharset));
            message.setStringProperty("JMSXUserID", this.getHostUserID(request));
            JSONObject jsonObj = new JSONObject(request.getRequestMessage().getHeaderPart().getJsonString());
            String programName = (String)jsonObj.get("CICSProgramName");
            int outputdatalength = jsonObj.getInt("CICSLength") + 8;
            byte[] mqcihBytes = this.getMqcihTransformers().toHost((Object)this.getMqcih(outputdatalength, this.getHostPassword(request)), hostCharset);
            byte[] result = new byte[mqcihBytes.length + 8 + hostData.length];
            System.arraycopy(mqcihBytes, 0, result, 0, mqcihBytes.length);
            byte[] programBytes = MQFMT_NONE.getBytes(hostCharset);
            System.arraycopy(programName.getBytes(hostCharset), 0, programBytes, 0, programName.length());
            System.arraycopy(programBytes, 0, result, mqcihBytes.length, 8);
            System.arraycopy(hostData, 0, result, mqcihBytes.length + 8, hostData.length);
            message.writeBytes(result);
            return message;
        }
        catch (IOException e) {
            throw new RequestException(e);
        }
        catch (JMSException e) {
            throw new RequestException(e);
        }
        catch (JSONException e) {
            throw new RequestException(e);
        }
        catch (HeaderPartException e) {
            throw new RequestException(e);
        }
        catch (HostTransformException e) {
            throw new RequestException(e);
        }
    }

    public LegStarMessage createReplyMessage(BytesMessage jmsMessage, int dataLength) throws HostReceiveException {
        try {
            String format = jmsMessage.getStringProperty("JMS_IBM_Format");
            String hostCharset = this.getHostCharset(jmsMessage.getIntProperty("JMS_IBM_Character_Set"));
            if (format == null || !format.equals(MQFMT_CICS)) {
                throw new HostReceiveException("Reply does not hold an MQCIH header");
            }
            if (dataLength < 180) {
                throw new HostReceiveException("Reply too small to hold a MQCIH header");
            }
            byte[] mqcihHost = new byte[180];
            jmsMessage.readBytes(mqcihHost, 180);
            Mqcih mqcihJava = this.getMqcihTransformers().toJava(mqcihHost, hostCharset);
            if (mqcihJava.getMqcihCompcode() != 0) {
                byte[] errorBytes = new byte[dataLength - 180];
                jmsMessage.readBytes(errorBytes);
                throw new HostReceiveException(new String(errorBytes, hostCharset));
            }
            if (!mqcihJava.getMqcihFormat().equals(MQFMT_NONE.trim())) {
                throw new HostReceiveException("Reply data has format " + mqcihJava.getMqcihFormat() + " when none was expected");
            }
            byte[] programNameHost = new byte[8];
            jmsMessage.readBytes(programNameHost, 8);
            byte[] replyCommarea = new byte[dataLength - 180 - 8];
            jmsMessage.readBytes(replyCommarea);
            LegStarMessage reponseMessage = new LegStarMessage();
            reponseMessage.addDataPart(new CommareaPart(replyCommarea));
            return reponseMessage;
        }
        catch (HeaderPartException e) {
            throw new HostReceiveException(e);
        }
        catch (IOException e) {
            throw new HostReceiveException(e);
        }
        catch (HostTransformException e) {
            throw new HostReceiveException(e);
        }
        catch (JMSException e) {
            throw new HostReceiveException(e);
        }
    }

    public MqcihTransformers getMqcihTransformers() {
        return this._MqcihTransformers;
    }

    private Mqcih getMqcih(int outputdatalength, String password) {
        Mqcih mqcih = new Mqcih();
        mqcih.setMqcihOutputdatalength(outputdatalength);
        mqcih.setMqcihAuthenticator(password);
        mqcih.setMqcihGetwaitinterval((int)this.getReceiveTimeout());
        mqcih.setMqcihUowcontrol(273);
        mqcih.setMqcihFlags(6);
        mqcih.setMqcihReplytoformat(MQFMT_NONE);
        return mqcih;
    }

    private int getCCSID(String hostCharset) {
        if (hostCharset != null) {
            if (hostCharset.equals("IBM-Thai")) {
                return 838;
            }
            if (hostCharset.startsWith("IBM")) {
                return Integer.parseInt(hostCharset.substring(3));
            }
            if (hostCharset.startsWith("x-IBM")) {
                return Integer.parseInt(hostCharset.substring(5));
            }
        }
        return 500;
    }

    private String getHostCharset(int ccsid) {
        String num = Integer.toString(ccsid);
        if (num.startsWith("11") || num.equals("37")) {
            return "IBM0" + num;
        }
        if (num.equals("838")) {
            return "IBM-Thai";
        }
        return "IBM" + Integer.toString(ccsid);
    }
}

