/*
 * Decompiled with CFR 0.152.
 */
package com.legstar.mq.client;

import com.legstar.messaging.HeaderPartException;
import com.legstar.messaging.HostMessageFormatException;
import com.legstar.messaging.HostReceiveException;
import com.legstar.messaging.LegStarMessage;
import com.legstar.messaging.LegStarRequest;
import com.legstar.messaging.RequestException;
import com.legstar.mq.client.AbstractCicsMQ;
import com.legstar.mq.client.CicsMQConnectionException;
import com.legstar.mq.client.CicsMQEndpoint;
import javax.jms.BytesMessage;
import javax.jms.JMSException;
import javax.jms.Message;

public class CicsMQLsmsg
extends AbstractCicsMQ {
    public CicsMQLsmsg(String connectionID, CicsMQEndpoint cicsMQEndpoint) throws CicsMQConnectionException {
        super(connectionID, cicsMQEndpoint);
    }

    public Message createRequestMessage(LegStarRequest request) throws RequestException {
        try {
            BytesMessage message = this.getJmsQueueSession().createBytesMessage();
            message.setJMSCorrelationID(null);
            if (request.getAddress().isHostTraceMode()) {
                message.setStringProperty("JMSXAppID", "true " + request.getID());
            } else {
                message.setStringProperty("JMSXAppID", "false ");
            }
            message.setStringProperty("JMSXUserID", this.getHostUserID(request));
            message.writeBytes(request.getRequestMessage().toByteArray());
            return message;
        }
        catch (JMSException e) {
            throw new RequestException(e);
        }
        catch (HostMessageFormatException e) {
            throw new RequestException(e);
        }
    }

    public LegStarMessage createReplyMessage(BytesMessage jmsMessage, int dataLength) throws HostReceiveException {
        try {
            byte[] hostBytes = new byte[dataLength];
            if (dataLength > 0) {
                jmsMessage.readBytes(hostBytes);
            }
            LegStarMessage replyMessage = new LegStarMessage();
            replyMessage.fromByteArray(hostBytes, 0);
            return replyMessage;
        }
        catch (HeaderPartException e) {
            throw new HostReceiveException(e);
        }
        catch (HostMessageFormatException e) {
            throw new HostReceiveException(e);
        }
        catch (JMSException e) {
            throw new HostReceiveException(e);
        }
    }
}

