/*
 * Decompiled with CFR 0.152.
 */
package com.legstar.mq.client;

import com.legstar.messaging.ConnectionFactory;
import com.legstar.messaging.HostEndpoint;
import com.legstar.mq.client.CicsMQConnectionException;

public class CicsMQEndpoint
extends HostEndpoint {
    private String _initialContextFactory;
    private String _jndiProviderURL;
    private String _jndiUrlPkgPrefixes;
    private String _jndiProperties;
    private String _jndiConnectionFactoryName;
    private String _jndiRequestQueueName;
    private String _jndiReplyQueueName;
    private HostMQBridgeType _hostMQBridgeType = HostMQBridgeType.LSMSG;
    private static final String DEFAULT_CONNECTION_FACTORY_CLASS = "com.legstar.mq.client.CicsMQConnectionFactory";
    private static final String INITIAL_CONTEXT_FACTORY_LABEL = "initialContextFactory";
    private static final String JNDI_PROVIDER_URL_LABEL = "jndiProviderURL";
    private static final String JNDI_URL_PKGP_REFIXES_LABEL = "jndiUrlPkgPrefixes";
    private static final String JNDI_PROPERTIES_LABEL = "jndiProperties";
    private static final String JNDI_CONNECTION_FACTORY_NAME_LABEL = "jndiConnectionFactoryName";
    private static final String JNDI_REQUEST_QUEUE_NAME_LABEL = "jndiRequestQueueName";
    private static final String JNDI_REPLY_QUEUE_NAME_LABEL = "jndiReplyQueueName";
    private static final String HOST_MQ_BRIDGE_TYPE_LABEL = "hostMQBridgeType";

    public CicsMQEndpoint() {
        this.setHostConnectionfactoryClass(DEFAULT_CONNECTION_FACTORY_CLASS);
    }

    public CicsMQEndpoint(ConnectionFactory connectionFactory) {
        super(connectionFactory);
    }

    public CicsMQEndpoint(CicsMQEndpoint copyFrom) {
        super(copyFrom);
        this.setInitialContextFactory(copyFrom.getInitialContextFactory());
        this.setJndiProviderURL(copyFrom.getJndiProviderURL());
        this.setJndiUrlPkgPrefixes(copyFrom.getJndiUrlPkgPrefixes());
        this.setJndiProperties(copyFrom.getJndiProperties());
        this.setJndiConnectionFactoryName(copyFrom.getJndiConnectionFactoryName());
        this.setJndiRequestQueueName(copyFrom.getJndiRequestQueueName());
        this.setJndiReplyQueueName(copyFrom.getJndiReplyQueueName());
        this.setHostMQBridgeType(copyFrom.getHostMQBridgeType());
    }

    public String toString() {
        String report = "CICS WMQ endpoint:" + super.toString() + "[" + INITIAL_CONTEXT_FACTORY_LABEL + "=" + this._initialContextFactory + "," + JNDI_PROVIDER_URL_LABEL + "=" + this._jndiProviderURL + "," + JNDI_URL_PKGP_REFIXES_LABEL + "=" + this._jndiUrlPkgPrefixes + "," + JNDI_PROPERTIES_LABEL + "={" + this._jndiProperties + "}," + JNDI_CONNECTION_FACTORY_NAME_LABEL + "=" + this._jndiConnectionFactoryName + "," + JNDI_REQUEST_QUEUE_NAME_LABEL + "=" + this._jndiRequestQueueName + "," + JNDI_REPLY_QUEUE_NAME_LABEL + "=" + this._jndiReplyQueueName + "," + HOST_MQ_BRIDGE_TYPE_LABEL + "=" + (Object)((Object)this._hostMQBridgeType) + "]";
        return report;
    }

    public void check() throws CicsMQConnectionException {
        if (this.getJndiConnectionFactoryName() == null || this.getJndiConnectionFactoryName().length() == 0) {
            throw new CicsMQConnectionException("No JNDI JMS connection factory name provided.");
        }
        if (this.getJndiRequestQueueName() == null || this.getJndiRequestQueueName().length() == 0) {
            throw new CicsMQConnectionException("No JNDI request queue name has been provided.");
        }
        if (this.getJndiReplyQueueName() == null || this.getJndiReplyQueueName().length() == 0) {
            throw new CicsMQConnectionException("No JNDI reply queue name has been provided.");
        }
    }

    public HostMQBridgeType getHostMQBridgeType() {
        return this._hostMQBridgeType;
    }

    public void setHostMQBridgeType(HostMQBridgeType hostMQBridgeType) {
        this._hostMQBridgeType = hostMQBridgeType;
    }

    public void setHostMQBridgeType(String hostMQBridgeType) {
        this._hostMQBridgeType = HostMQBridgeType.valueOf(hostMQBridgeType);
    }

    public void setPooledMaxIdleTime(long maxIdleTime) {
        if (maxIdleTime != -1L) {
            throw new IllegalArgumentException("pooledMaxIdleTime not supported by this transport");
        }
        super.setPooledMaxIdleTime(maxIdleTime);
    }

    public void setPooledMaxIdleTimeCheckPeriod(long pooledMaxIdleTimeCheckPeriod) {
        if (pooledMaxIdleTimeCheckPeriod != -1L) {
            throw new IllegalArgumentException("pooledMaxIdleTimeCheckPeriod not supported by this transport");
        }
        super.setPooledMaxIdleTimeCheckPeriod(pooledMaxIdleTimeCheckPeriod);
    }

    public String getInitialContextFactory() {
        return this._initialContextFactory;
    }

    public void setInitialContextFactory(String initialContextFactory) {
        this._initialContextFactory = initialContextFactory;
    }

    public String getJndiConnectionFactoryName() {
        return this._jndiConnectionFactoryName;
    }

    public void setJndiConnectionFactoryName(String jndiConnectionFactoryName) {
        this._jndiConnectionFactoryName = jndiConnectionFactoryName;
    }

    public String getJndiProviderURL() {
        return this._jndiProviderURL;
    }

    public void setJndiProviderURL(String jndiProviderURL) {
        this._jndiProviderURL = jndiProviderURL;
    }

    public String getJndiUrlPkgPrefixes() {
        return this._jndiUrlPkgPrefixes;
    }

    public void setJndiUrlPkgPrefixes(String jndiUrlPkgPrefixes) {
        this._jndiUrlPkgPrefixes = jndiUrlPkgPrefixes;
    }

    public String getJndiProperties() {
        return this._jndiProperties;
    }

    public void setJndiProperties(String jndiProperties) {
        this._jndiProperties = jndiProperties;
    }

    public String getJndiRequestQueueName() {
        return this._jndiRequestQueueName;
    }

    public void setJndiRequestQueueName(String jndiRequestQueueName) {
        this._jndiRequestQueueName = jndiRequestQueueName;
    }

    public String getJndiReplyQueueName() {
        return this._jndiReplyQueueName;
    }

    public void setJndiReplyQueueName(String jndiReplyQueueName) {
        this._jndiReplyQueueName = jndiReplyQueueName;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum HostMQBridgeType {
        LSMSG,
        MQCIH;

    }
}

