/*
 * Decompiled with CFR 0.152.
 */
package com.legstar.mq.client;

import com.legstar.messaging.ConnectionException;
import com.legstar.messaging.HeaderPartException;
import com.legstar.messaging.HostReceiveException;
import com.legstar.messaging.LegStarConnection;
import com.legstar.messaging.LegStarMessage;
import com.legstar.messaging.LegStarRequest;
import com.legstar.messaging.RequestException;
import com.legstar.mq.client.CicsMQConnectionException;
import com.legstar.mq.client.CicsMQEndpoint;
import java.util.Map;
import java.util.Properties;
import javax.jms.BytesMessage;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.MessageProducer;
import javax.jms.QueueConnection;
import javax.jms.QueueConnectionFactory;
import javax.jms.QueueSession;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class AbstractCicsMQ
implements LegStarConnection {
    private String _connectionID;
    private CicsMQEndpoint _cicsMQEndpoint;
    private Context _jndiContext;
    private QueueConnection _jmsConnection;
    private QueueSession _jmsQueueSession;
    private Destination _jmsRequestQueue;
    private Destination _jmsReplyQueue;
    private boolean _isOpen;
    private long _lastUsedTime = -1L;
    private final Log _log = LogFactory.getLog(this.getClass());

    public AbstractCicsMQ(String connectionID, CicsMQEndpoint cicsMQEndpoint) throws CicsMQConnectionException {
        this._connectionID = connectionID;
        this._cicsMQEndpoint = cicsMQEndpoint;
        this._jndiContext = this.createJndiContext(cicsMQEndpoint);
    }

    protected Context createJndiContext(CicsMQEndpoint cicsMQEndpoint) throws CicsMQConnectionException {
        try {
            Properties env = new Properties();
            if (cicsMQEndpoint.getInitialContextFactory() != null && cicsMQEndpoint.getInitialContextFactory().length() > 0) {
                env.put("java.naming.factory.initial", cicsMQEndpoint.getInitialContextFactory());
            }
            if (cicsMQEndpoint.getJndiProviderURL() != null && cicsMQEndpoint.getJndiProviderURL().length() > 0) {
                env.put("java.naming.provider.url", cicsMQEndpoint.getJndiProviderURL());
            }
            if (cicsMQEndpoint.getJndiUrlPkgPrefixes() != null && cicsMQEndpoint.getJndiUrlPkgPrefixes().length() > 0) {
                env.put("java.naming.factory.url.pkgs", cicsMQEndpoint.getJndiUrlPkgPrefixes());
            }
            if (cicsMQEndpoint.getJndiProperties() != null) {
                env.putAll((Map<?, ?>)this.getProperties(cicsMQEndpoint.getJndiProperties()));
            }
            if (env.size() > 0) {
                return new InitialContext(env);
            }
            return new InitialContext();
        }
        catch (NamingException e) {
            throw new CicsMQConnectionException(e);
        }
    }

    public void connect(String mqPassword) throws ConnectionException {
        if (this._log.isDebugEnabled()) {
            this._log.debug("Connection:" + this._connectionID + " Attempting connection. Host:" + this.getCicsMQEndpoint().toString());
        }
        String password = mqPassword == null || mqPassword.length() == 0 ? this.getCicsMQEndpoint().getHostPassword() : mqPassword;
        this._jmsConnection = this.createQueueConnection(this.getCicsMQEndpoint().getHostUserID(), password);
        this._jmsQueueSession = this.createQueueSession();
        this._jmsRequestQueue = this.createRequestQueue();
        this._jmsReplyQueue = this.createReplyQueue();
        this._isOpen = true;
        this._lastUsedTime = System.currentTimeMillis();
        if (this._log.isDebugEnabled()) {
            this._log.debug("Connection:" + this._connectionID + " Connected.");
        }
    }

    protected QueueConnection createQueueConnection(String userId, String password) throws CicsMQConnectionException {
        if (this._log.isDebugEnabled()) {
            this._log.debug("enter createQueueConnection()");
        }
        try {
            QueueConnectionFactory factory = (QueueConnectionFactory)this.getJndiContext().lookup(this.getCicsMQEndpoint().getJndiConnectionFactoryName());
            if (factory == null) {
                throw new CicsMQConnectionException("JNDI lookup for " + this.getCicsMQEndpoint().getJndiConnectionFactoryName() + " failed");
            }
            QueueConnection connection = factory.createQueueConnection(userId, password);
            connection.start();
            return connection;
        }
        catch (NamingException e) {
            throw new CicsMQConnectionException(e);
        }
        catch (JMSException e) {
            throw new CicsMQConnectionException(e);
        }
    }

    protected QueueSession createQueueSession() throws CicsMQConnectionException {
        try {
            boolean transacted = false;
            QueueSession session = this.getJmsConnection().createQueueSession(transacted, 1);
            return session;
        }
        catch (JMSException e) {
            throw new CicsMQConnectionException(e);
        }
    }

    protected Destination createRequestQueue() throws CicsMQConnectionException {
        return this.createQueue(this.getCicsMQEndpoint().getJndiRequestQueueName());
    }

    protected Destination createReplyQueue() throws CicsMQConnectionException {
        return this.createQueue(this.getCicsMQEndpoint().getJndiReplyQueueName());
    }

    protected Destination createQueue(String queueJndiName) throws CicsMQConnectionException {
        if (this._log.isDebugEnabled()) {
            this._log.debug("enter createQueue() for  " + queueJndiName);
        }
        try {
            Destination queue = (Destination)this.getJndiContext().lookup(queueJndiName);
            if (queue == null) {
                throw new CicsMQConnectionException("JNDI lookup for " + queueJndiName + " failed");
            }
            return queue;
        }
        catch (NamingException e) {
            throw new CicsMQConnectionException(e);
        }
    }

    public void close() throws RequestException {
        if (this._log.isDebugEnabled()) {
            this._log.debug("Connection:" + this._connectionID + " closing.");
        }
        if (this._jmsQueueSession != null) {
            try {
                this._jmsQueueSession.close();
            }
            catch (JMSException e) {
                this._log.error(e);
            }
        }
        if (this._jmsConnection != null) {
            try {
                this._jmsConnection.close();
            }
            catch (JMSException e) {
                this._log.error(e);
            }
        }
        this._jmsRequestQueue = null;
        this._jmsReplyQueue = null;
        this._jmsQueueSession = null;
        this._jmsConnection = null;
        this._isOpen = false;
        this._lastUsedTime = System.currentTimeMillis();
    }

    public void connectReuse(String mqPassword) throws ConnectionException {
        if (this._log.isDebugEnabled()) {
            this._log.debug("Connection:" + this._connectionID + " Attempting reuse.");
        }
        if (this.isOpen()) {
            if (this._log.isDebugEnabled()) {
                this._log.debug("Connection:" + this._connectionID + " Connection will be reused.");
            }
            this._lastUsedTime = System.currentTimeMillis();
            return;
        }
        if (this._log.isDebugEnabled()) {
            this._log.debug("Connection:" + this._connectionID + " Connection not reusable.");
        }
        this.connect(mqPassword);
    }

    public void sendRequest(LegStarRequest request) throws RequestException {
        MessageProducer producer = null;
        try {
            if (this._log.isDebugEnabled()) {
                this._log.debug("Sending Request:" + request.getID() + " on Connection:" + this._connectionID + " " + request.getRequestMessage().getHeaderPart().getJsonString() + '.');
            }
            Message jmsMessage = this.createRequestMessage(request);
            jmsMessage.setJMSReplyTo(this.getJmsReplyQueue());
            producer = this.getJmsQueueSession().createProducer(this.getJmsRequestQueue());
            producer.send(jmsMessage);
            request.setAttachment(jmsMessage.getJMSMessageID().getBytes());
            this._lastUsedTime = System.currentTimeMillis();
            if (this._log.isDebugEnabled()) {
                this._log.debug("Sent Request:" + request.getID() + " on Connection:" + this._connectionID + ". Message ID:" + jmsMessage.getJMSMessageID());
            }
        }
        catch (HeaderPartException e) {
            throw new RequestException(e);
        }
        catch (JMSException e) {
            throw new RequestException(e);
        }
        finally {
            if (producer != null) {
                try {
                    producer.close();
                }
                catch (JMSException e) {
                    this._log.error(e);
                }
            }
        }
    }

    public void recvResponse(LegStarRequest request) throws RequestException {
        MessageConsumer consumer = null;
        try {
            Message jmsMessage;
            String selector = "JMSCorrelationID='" + new String(request.getAttachment()) + "'";
            if (this._log.isDebugEnabled()) {
                this._log.debug("Receiving response for Request:" + request.getID() + " on Connection:" + this._connectionID + ". Selector: " + selector);
            }
            if (!((jmsMessage = (consumer = this.getJmsQueueSession().createConsumer(this.getJmsReplyQueue(), selector)).receive(this.getCicsMQEndpoint().getReceiveTimeout())) instanceof BytesMessage)) {
                throw new RequestException("Message received does not contain bytes");
            }
            BytesMessage message = (BytesMessage)jmsMessage;
            message.reset();
            long dataLength = message.getBodyLength();
            if (dataLength > Integer.MAX_VALUE) {
                throw new RequestException("Size of BytesMessage exceeds Integer.MAX_VALUE");
            }
            request.setResponseMessage(this.createReplyMessage(message, (int)dataLength));
            this._lastUsedTime = System.currentTimeMillis();
            if (this._log.isDebugEnabled()) {
                this._log.debug("Received response for Request:" + request.getID() + " on Connection:" + this._connectionID + ". Selector: " + selector);
            }
        }
        catch (JMSException e) {
            throw new RequestException(e);
        }
        catch (HostReceiveException e) {
            throw new RequestException(e);
        }
        finally {
            if (consumer != null) {
                try {
                    consumer.close();
                }
                catch (JMSException e) {
                    this._log.error(e);
                }
            }
        }
    }

    public abstract Message createRequestMessage(LegStarRequest var1) throws RequestException;

    public abstract LegStarMessage createReplyMessage(BytesMessage var1, int var2) throws HostReceiveException;

    public void commitUOW() throws RequestException {
    }

    public void keepUOW() throws RequestException {
    }

    public void rollbackUOW() throws RequestException {
    }

    public String getConnectionID() {
        return this._connectionID;
    }

    public CicsMQEndpoint getCicsMQEndpoint() {
        return this._cicsMQEndpoint;
    }

    public String getHostUserID(LegStarRequest request) {
        String hostUserID = request.getAddress().getHostUserID();
        if (hostUserID == null) {
            return this.getCicsMQEndpoint().getHostUserID();
        }
        return hostUserID;
    }

    public String getHostCharset(LegStarRequest request) {
        String hostCharset = request.getAddress().getHostCharset();
        if (hostCharset == null) {
            return this.getCicsMQEndpoint().getHostCharset();
        }
        return hostCharset;
    }

    public Properties getProperties(String properties) {
        String[] keyValuePairs;
        Properties result = new Properties();
        for (String keyValuePair : keyValuePairs = properties.split(",")) {
            String[] entry = keyValuePair.split("=");
            if (entry.length != 2) continue;
            result.put(entry[0], entry[1]);
        }
        return result;
    }

    public String getHostPassword(LegStarRequest request) {
        String hostPassword = request.getAddress().getHostPassword();
        if (hostPassword == null) {
            return this.getCicsMQEndpoint().getHostPassword();
        }
        return hostPassword;
    }

    public long getConnectTimeout() {
        return this.getCicsMQEndpoint().getConnectTimeout();
    }

    public long getReceiveTimeout() {
        return this.getCicsMQEndpoint().getReceiveTimeout();
    }

    public boolean isOpen() {
        return this._isOpen;
    }

    public long getLastUsedTime() {
        return this._lastUsedTime;
    }

    public Context getJndiContext() {
        return this._jndiContext;
    }

    public QueueConnection getJmsConnection() {
        return this._jmsConnection;
    }

    public QueueSession getJmsQueueSession() {
        return this._jmsQueueSession;
    }

    public Destination getJmsRequestQueue() {
        return this._jmsRequestQueue;
    }

    public Destination getJmsReplyQueue() {
        return this._jmsReplyQueue;
    }
}

