/*
 * Decompiled with CFR 0.152.
 */
package com.legstar.mock.client;

import com.legstar.coxb.CobolContext;
import com.legstar.coxb.convert.CobolConversionException;
import com.legstar.coxb.convert.simple.CobolBinarySimpleConverter;
import com.legstar.coxb.convert.simple.CobolPackedDecimalSimpleConverter;
import com.legstar.coxb.convert.simple.CobolStringSimpleConverter;
import com.legstar.messaging.ContainerPart;
import com.legstar.messaging.HeaderPartException;
import com.legstar.messaging.LegStarMessage;
import com.legstar.messaging.LegStarMessagePart;
import com.legstar.messaging.RequestException;
import com.legstar.mock.client.MockFILEA;
import java.math.BigDecimal;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class MockLsfileac {
    private static final Log LOG = LogFactory.getLog(MockLsfileac.class);
    private static final MockFILEA FILEA = new MockFILEA();

    private MockLsfileac() {
    }

    public static LegStarMessage getResponse(LegStarMessage requestMessage) throws RequestException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Building response for program LSFILEAC");
        }
        try {
            byte[] queryData = null;
            byte[] queryLimit = null;
            for (LegStarMessagePart part : requestMessage.getDataParts()) {
                if (part.getPartID().equals("QueryData")) {
                    queryData = part.getContent();
                }
                if (!part.getPartID().equals("QueryLimit")) continue;
                queryLimit = part.getContent();
            }
            String namePattern = queryData == null ? "*" : MockLsfileac.getQueryName(queryData);
            List<byte[]> customers = queryLimit == null ? FILEA.getCustomers(namePattern) : FILEA.getCustomers(namePattern, MockLsfileac.getMaxItems(queryLimit));
            int offset = 0;
            String hostCharsetName = CobolContext.getDefaultHostCharsetName();
            byte[] hostReplyStatus = new byte[151];
            CobolBinarySimpleConverter.toHostSingle(BigDecimal.ZERO, 2, false, hostReplyStatus, offset);
            CobolStringSimpleConverter.toHostSingle("00:00:00", hostCharsetName, null, 8, false, hostReplyStatus, offset += 2);
            CobolPackedDecimalSimpleConverter.toHostSingle(new BigDecimal(FILEA.getCustomersNumber()), 5, 8, 0, false, hostReplyStatus, offset += 8);
            CobolBinarySimpleConverter.toHostSingle(BigDecimal.ZERO, 4, true, hostReplyStatus, offset += 5);
            CobolBinarySimpleConverter.toHostSingle(BigDecimal.ZERO, 4, true, hostReplyStatus, offset += 4);
            CobolStringSimpleConverter.toHostSingle(customers.size() > 0 ? "" : "NO CUSTOMER SATISFIES YOUR QUERY", hostCharsetName, null, 128, false, hostReplyStatus, offset += 4);
            offset += 128;
            offset = 0;
            byte[] hostReplyData = null;
            if (customers.size() > 0) {
                hostReplyData = new byte[5 + 79 * customers.size()];
                CobolPackedDecimalSimpleConverter.toHostSingle(new BigDecimal(customers.size()), 5, 8, 0, false, hostReplyData, offset);
                offset += 5;
                for (byte[] customer : customers) {
                    System.arraycopy(customer, 0, hostReplyData, offset, 79);
                    offset += 79;
                }
            }
            LegStarMessage replyMessage = new LegStarMessage();
            replyMessage.addDataPart(new ContainerPart("ReplyStatus", hostReplyStatus));
            replyMessage.addDataPart(new ContainerPart("ReplyData", hostReplyData));
            return replyMessage;
        }
        catch (HeaderPartException e) {
            throw new RequestException(e);
        }
        catch (CobolConversionException e) {
            throw new RequestException(e);
        }
    }

    private static String getQueryName(byte[] hostData) {
        try {
            return CobolStringSimpleConverter.fromHostSingle(CobolContext.getDefaultHostCharsetName(), 20, hostData, 0);
        }
        catch (CobolConversionException e) {
            e.printStackTrace();
            return null;
        }
    }

    private static long getMaxItems(byte[] hostData) {
        try {
            BigDecimal bigD = CobolPackedDecimalSimpleConverter.fromHostSingle(5, 8, 0, hostData, 0);
            return bigD.longValue();
        }
        catch (CobolConversionException e) {
            e.printStackTrace();
            return 0L;
        }
    }
}

