/*
 * Decompiled with CFR 0.152.
 */
package com.legstar.mock.client;

import com.legstar.coxb.CobolContext;
import com.legstar.coxb.convert.CobolConversionException;
import com.legstar.coxb.convert.simple.CobolStringSimpleConverter;
import com.legstar.coxb.convert.simple.CobolZonedDecimalSimpleConverter;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MockFILEA {
    public static final String TEXT_DATA_FILE = "/dfh$fain";
    private Map<BigDecimal, byte[]> _hostCustomersList;
    private final Log _log = LogFactory.getLog(MockFILEA.class);

    public MockFILEA() {
        try {
            this._hostCustomersList = new LinkedHashMap<BigDecimal, byte[]>();
            InputStream is = this.getClass().getResourceAsStream(TEXT_DATA_FILE);
            BufferedReader in = new BufferedReader(new InputStreamReader(is));
            String record = null;
            while ((record = in.readLine()) != null) {
                this._log.debug(record);
                byte[] hostRecord = this.getHostRecord(record);
                if (hostRecord == null) continue;
                this._hostCustomersList.put(new BigDecimal(record.substring(1, 7)), hostRecord);
            }
            in.close();
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    public byte[] getCustomer(byte[] customerId) {
        try {
            BigDecimal bigId = CobolZonedDecimalSimpleConverter.fromHostSingle(6, 6, 0, false, false, false, customerId, 0, CobolContext.getDefaultHostCharsetName());
            return this._hostCustomersList.get(bigId);
        }
        catch (CobolConversionException e) {
            e.printStackTrace();
            return null;
        }
    }

    public int getCustomersNumber() {
        return this._hostCustomersList.size();
    }

    public List<byte[]> getCustomers(String namePattern) {
        return this.getCustomers(namePattern, -1L, this._hostCustomersList.size());
    }

    public List<byte[]> getCustomers(String namePattern, long maxItems) {
        return this.getCustomers(namePattern, -1L, maxItems);
    }

    public List<byte[]> getCustomers(String namePattern, long maxItems, long maxReplies) {
        ArrayList<byte[]> list = new ArrayList<byte[]>();
        int itemsExamined = 0;
        for (byte[] dfhcommarea : this._hostCustomersList.values()) {
            boolean match = true;
            String name = this.getCustomerName(dfhcommarea);
            if (namePattern != null) {
                for (int i = 0; i < namePattern.length() && namePattern.charAt(i) != '*'; ++i) {
                    if (namePattern.charAt(i) == name.charAt(i)) continue;
                    match = false;
                    break;
                }
            }
            if (match) {
                if (maxReplies > -1L && (long)list.size() == maxReplies) break;
                list.add(dfhcommarea);
            }
            if (maxItems <= -1L || (long)(++itemsExamined) <= maxItems) continue;
            break;
        }
        return list;
    }

    private String getCustomerName(byte[] dfhcommarea) {
        try {
            return CobolStringSimpleConverter.fromHostSingle(CobolContext.getDefaultHostCharsetName(), 20, dfhcommarea, 6);
        }
        catch (CobolConversionException e) {
            e.printStackTrace();
            return null;
        }
    }

    private byte[] getHostRecord(String record) {
        if (record.length() != 80) {
            return null;
        }
        int offset = 0;
        byte[] hostRecord = new byte[79];
        String hostCharsetName = CobolContext.getDefaultHostCharsetName();
        try {
            CobolZonedDecimalSimpleConverter.toHostSingle(new BigDecimal(record.substring(1, 7)), 6, 6, 0, false, false, false, hostRecord, offset, hostCharsetName);
            CobolStringSimpleConverter.toHostSingle(record.substring(7, 27), hostCharsetName, null, 20, false, hostRecord, offset += 6);
            CobolStringSimpleConverter.toHostSingle(record.substring(27, 47), hostCharsetName, null, 20, false, hostRecord, offset += 20);
            CobolStringSimpleConverter.toHostSingle(record.substring(47, 55), hostCharsetName, null, 8, false, hostRecord, offset += 20);
            CobolStringSimpleConverter.toHostSingle(record.substring(55, 63), hostCharsetName, null, 8, false, hostRecord, offset += 8);
            CobolStringSimpleConverter.toHostSingle(record.substring(63, 71), hostCharsetName, null, 8, false, hostRecord, offset += 8);
            CobolStringSimpleConverter.toHostSingle("*********", hostCharsetName, null, 9, false, hostRecord, offset += 8);
            offset += 9;
        }
        catch (CobolConversionException e) {
            e.printStackTrace();
            return null;
        }
        return hostRecord;
    }
}

