/*
 * Decompiled with CFR 0.152.
 */
package com.legstar.messaging;

import com.legstar.messaging.LegStarAddress;
import com.legstar.messaging.LegStarMessage;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;

public class LegStarRequest {
    private String mID;
    private LegStarMessage mRequestMessage;
    private LegStarMessage mResponseMessage;
    private Exception mException;
    private LegStarAddress mAddress;
    private byte[] mAttachment;
    private CountDownLatch mProcessingLatch = null;

    public LegStarRequest() {
    }

    public LegStarRequest(String id, LegStarAddress address, LegStarMessage requestMessage) {
        this.mID = id;
        this.mAddress = address;
        this.mRequestMessage = requestMessage;
    }

    public String getID() {
        return this.mID;
    }

    public void setID(String id) {
        this.mID = id;
    }

    public LegStarMessage getRequestMessage() {
        return this.mRequestMessage;
    }

    public void setRequestMessage(LegStarMessage requestMessage) {
        this.mRequestMessage = requestMessage;
    }

    public LegStarMessage getResponseMessage() {
        return this.mResponseMessage;
    }

    public void setResponseMessage(LegStarMessage responseMessage) {
        this.mResponseMessage = responseMessage;
    }

    public Exception getException() {
        return this.mException;
    }

    public void setException(Exception requestException) {
        this.mException = requestException;
    }

    public LegStarAddress getAddress() {
        return this.mAddress;
    }

    public void setAddress(LegStarAddress address) {
        this.mAddress = address;
    }

    public byte[] getAttachment() {
        return this.mAttachment;
    }

    public void setAttachment(byte[] attachment) {
        this.mAttachment = attachment;
    }

    public void signalProcessingStart() {
        this.mProcessingLatch = new CountDownLatch(1);
    }

    public void signalProcessingStop() {
        this.mProcessingLatch.countDown();
    }

    public boolean await(long timeout, TimeUnit unit) throws InterruptedException {
        if (this.mProcessingLatch == null) {
            return true;
        }
        return this.mProcessingLatch.await(timeout, unit);
    }
}

