/*
 * Decompiled with CFR 0.152.
 */
package com.legstar.messaging;

import com.legstar.codec.HostCodec;
import com.legstar.coxb.host.HostData;
import com.legstar.messaging.HostMessageFormatException;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.util.Arrays;

public class LegStarMessagePart
implements Serializable {
    private static final long serialVersionUID = -2361247952255347371L;
    private String mPartID;
    private byte[] mContent;
    private int mPayloadSize;
    private boolean mPayloadSizeSet = false;
    private static final int MSG_PART_ID_LEN = 16;
    private static final int CONTENT_LEN_LEN = 4;
    private static final String ERROR_ID = "LSOKERR0";
    private static final int MAX_CONTENT_LEN = 0x1000000;

    public LegStarMessagePart() {
        this.mPartID = null;
    }

    public LegStarMessagePart(String id, byte[] content) {
        this.mPartID = id;
        this.mContent = content;
    }

    public byte[] getContent() {
        return this.mContent;
    }

    public void setContent(byte[] content) {
        this.mContent = content;
    }

    public String getPartID() {
        return this.mPartID;
    }

    public void setPartID(String partID) throws HostMessageFormatException {
        if (this.getPartID() == null) {
            if (partID.length() > 16) {
                throw new HostMessageFormatException("Invalid message part ID " + partID);
            }
            this.mPartID = partID;
        } else if (!this.getPartID().equals(partID)) {
            throw new HostMessageFormatException("Invalid message part ID. Expected " + this.getPartID() + ", received " + partID);
        }
    }

    public int getHostSize() {
        return 20 + this.getPayloadSize();
    }

    public byte[] toByteArray() throws HostMessageFormatException {
        byte[] payload = new byte[this.getHostSize()];
        this.toByteArray(payload, 0);
        return payload;
    }

    public int toByteArray(byte[] dest, int destPos) throws HostMessageFormatException {
        if (dest.length - destPos < this.getHostSize()) {
            throw new HostMessageFormatException("Destination byte array too small");
        }
        try {
            int pos = destPos;
            HostCodec.toHostBytes(this.mPartID, dest, pos, 16, "IBM1047");
            pos += 16;
            ByteBuffer bb = ByteBuffer.allocate(4);
            bb.putInt(this.getPayloadSize());
            bb.flip();
            bb.get(dest, pos, 4);
            pos += 4;
            if (this.getContent() != null) {
                System.arraycopy(this.getContent(), 0, dest, pos, this.getPayloadSize());
            }
            return pos + this.getPayloadSize();
        }
        catch (UnsupportedEncodingException e) {
            throw new HostMessageFormatException(e);
        }
    }

    public int fromByteArray(byte[] src, int srcPos) throws HostMessageFormatException {
        try {
            if (src.length - srcPos < ERROR_ID.length()) {
                throw new HostMessageFormatException("Invalid message part");
            }
            String errorId = new String(src, srcPos, ERROR_ID.length(), "IBM1047").trim();
            if (errorId.equals(ERROR_ID)) {
                throw this.getHostException(src, srcPos);
            }
            if (src.length - srcPos < 20) {
                throw new HostMessageFormatException("Invalid message part. No ID");
            }
            int pos = srcPos;
            String partId = new String(src, pos, 16, "IBM1047").trim();
            this.setPartID(partId);
            int contentLen = this.getContentLength(src, pos += 16);
            return this.setContent(src, pos += 4, contentLen);
        }
        catch (UnsupportedEncodingException e) {
            throw new HostMessageFormatException(e);
        }
    }

    public void fromStream(InputStream stream) throws HostMessageFormatException {
        try {
            byte[] partIDBytes = new byte[16];
            int readBytes = stream.read(partIDBytes, 0, ERROR_ID.length());
            if (readBytes < ERROR_ID.length()) {
                throw new HostMessageFormatException("Invalid message part");
            }
            String errorId = new String(partIDBytes, 0, ERROR_ID.length(), "IBM1047").trim();
            if (errorId.equals(ERROR_ID)) {
                throw this.getHostException(stream);
            }
            if ((readBytes += stream.read(partIDBytes, ERROR_ID.length(), 16 - ERROR_ID.length())) < 16) {
                throw new HostMessageFormatException("Invalid message part. No ID");
            }
            String partId = new String(partIDBytes, 0, 16, "IBM1047").trim();
            this.setPartID(partId);
            int contentLen = this.getContentLength(stream);
            this.setContent(stream, contentLen);
        }
        catch (IOException e) {
            throw new HostMessageFormatException(e);
        }
    }

    public HostMessageFormatException getHostException(byte[] src, int srcPos) {
        try {
            int pos = srcPos + ERROR_ID.length() + 1;
            String errorText = new String(src, pos, src.length - pos, "IBM1047").trim();
            return new HostMessageFormatException(errorText);
        }
        catch (UnsupportedEncodingException e) {
            return new HostMessageFormatException(e);
        }
    }

    public HostMessageFormatException getHostException(InputStream stream) {
        try {
            byte[] msgBytes = new byte[stream.available()];
            stream.read(msgBytes);
            String errorText = new String(msgBytes, 0, msgBytes.length, "IBM1047").trim();
            return new HostMessageFormatException(errorText);
        }
        catch (UnsupportedEncodingException e) {
            return new HostMessageFormatException(e);
        }
        catch (IOException e) {
            return new HostMessageFormatException(e);
        }
    }

    public int getContentLength(byte[] src, int srcPos) throws HostMessageFormatException {
        ByteBuffer bb = ByteBuffer.allocate(4);
        bb.put(src, srcPos, 4);
        bb.flip();
        int contentLen = bb.getInt();
        if (contentLen < 0 || contentLen > 0x1000000) {
            throw new HostMessageFormatException("Invalid message part content length " + contentLen);
        }
        return contentLen;
    }

    public int getContentLength(InputStream stream) throws HostMessageFormatException {
        try {
            byte[] clBytes = new byte[4];
            int readBytes = stream.read(clBytes);
            if (readBytes < 4) {
                throw new HostMessageFormatException("Invalid message part content length ");
            }
            ByteBuffer bb = ByteBuffer.allocate(4);
            bb.put(clBytes, 0, 4);
            bb.flip();
            int contentLen = bb.getInt();
            if (contentLen < 0 || contentLen > 0x1000000) {
                throw new HostMessageFormatException("Invalid message part content length " + contentLen);
            }
            return contentLen;
        }
        catch (IOException e) {
            throw new HostMessageFormatException(e);
        }
    }

    public int setContent(byte[] src, int srcPos, int contentLen) throws HostMessageFormatException {
        if (contentLen == 0) {
            this.setContent(null);
        } else {
            byte[] content = new byte[contentLen];
            System.arraycopy(src, srcPos, content, 0, contentLen);
            this.setContent(content);
        }
        return srcPos + contentLen;
    }

    public void setContent(InputStream stream, int contentLen) throws HostMessageFormatException {
        try {
            if (contentLen == 0) {
                this.setContent(null);
            } else {
                byte[] content = new byte[contentLen];
                for (int readBytes = 0; readBytes < contentLen; readBytes += stream.read(content, readBytes, contentLen - readBytes)) {
                }
                this.setContent(content);
            }
        }
        catch (IOException e) {
            throw new HostMessageFormatException(e);
        }
    }

    public String toString() {
        StringBuffer sb = new StringBuffer(80);
        sb.append(this.getClass().getSimpleName());
        sb.append("{this=").append(Integer.toHexString(System.identityHashCode(this)));
        sb.append(", id=").append(this.getPartID());
        sb.append(", content=[").append(HostData.toHexString(this.getContent(), 10));
        sb.append("]}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LegStarMessagePart)) {
            return false;
        }
        LegStarMessagePart msgPart = (LegStarMessagePart)obj;
        if (!msgPart.getPartID().equals(this.getPartID())) {
            return false;
        }
        return Arrays.equals(msgPart.getContent(), this.getContent());
    }

    public int hashCode() {
        return this.getPartID().hashCode() + Arrays.hashCode(this.getContent());
    }

    public int getPayloadSize() {
        if (this.mPayloadSizeSet) {
            return this.mPayloadSize;
        }
        if (this.mContent != null) {
            return this.mContent.length;
        }
        return 0;
    }

    public void setPayloadSize(int payloadSize) {
        if (this.mContent == null || payloadSize > this.mContent.length) {
            throw new IllegalArgumentException("Payload size cannot exceed content length");
        }
        this.mPayloadSize = payloadSize;
        this.mPayloadSizeSet = true;
    }

    public static boolean isLegStarMessagePart(byte[] payload, String partID) throws UnsupportedEncodingException {
        if (payload == null || payload.length < 16) {
            return false;
        }
        String id = new String(payload, 0, 16, "IBM1047").trim();
        return id.trim().equals(partID);
    }
}

