/*
 * Decompiled with CFR 0.152.
 */
package com.legstar.messaging;

import com.legstar.messaging.HeaderPartException;
import com.legstar.messaging.LegStarMessagePart;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LegStarHeaderPart
extends LegStarMessagePart {
    private static final long serialVersionUID = -4021804844084093286L;
    public static final String HEADER_PART_ID = "LSOKHEAD";
    private static final int DATAPARTS_NUM_LEN = 4;
    private static final int JSON_LEN_LEN = 4;

    public LegStarHeaderPart() throws HeaderPartException {
        super(HEADER_PART_ID, null);
        this.setContent(0, "");
    }

    public LegStarHeaderPart(int dataPartsNumber, String jsonString) throws HeaderPartException {
        super(HEADER_PART_ID, null);
        this.setContent(dataPartsNumber, jsonString);
    }

    public LegStarHeaderPart(Map<String, Object> keyValues, int dataPartsNumber) throws HeaderPartException {
        super(HEADER_PART_ID, null);
        this.setContent(dataPartsNumber, LegStarHeaderPart.getJsonFromMap(keyValues));
    }

    public void setContent(int dataPartsNumber, String jsonString) throws HeaderPartException {
        byte[] hostJson;
        try {
            hostJson = jsonString.getBytes("IBM1047");
        }
        catch (UnsupportedEncodingException e) {
            throw new HeaderPartException(e);
        }
        this.setContent(new byte[8 + hostJson.length]);
        int pos = 0;
        this.setDataPartsNumber(dataPartsNumber);
        pos += 4;
        ByteBuffer bb = ByteBuffer.allocate(4);
        bb.putInt(hostJson.length);
        bb.flip();
        bb.get(this.getContent(), pos, 4);
        pos += 4;
        if (hostJson.length > 0) {
            System.arraycopy(hostJson, 0, this.getContent(), pos, hostJson.length);
        }
    }

    public static String getJsonFromMap(Map<String, Object> map) {
        StringBuilder sb = new StringBuilder();
        boolean firstentry = true;
        sb.append("{");
        Map.Entry<String, Object> entry2 = null;
        for (Map.Entry<String, Object> entry2 : map.entrySet()) {
            if (entry2.getValue() instanceof String) {
                if (!firstentry) {
                    sb.append(",");
                }
                sb.append("\"" + entry2.getKey() + "\":\"" + entry2.getValue() + "\"");
            } else if (entry2.getValue() instanceof String[]) {
                if (!firstentry) {
                    sb.append(",");
                }
                sb.append("\"" + entry2.getKey() + "\":[");
                String[] array = (String[])entry2.getValue();
                for (int i = 0; i < array.length; ++i) {
                    if (i > 0) {
                        sb.append(",");
                    }
                    sb.append("\"" + array[i] + "\"");
                }
                sb.append("]");
            }
            if (!firstentry) continue;
            firstentry = false;
        }
        sb.append("}");
        return sb.toString();
    }

    public int getDataPartsNumber() {
        if (this.getContent() == null || this.getContent().length < 4) {
            return 0;
        }
        ByteBuffer bb = ByteBuffer.allocate(4);
        bb.put(this.getContent(), 0, 4);
        bb.flip();
        return bb.getInt();
    }

    public void setDataPartsNumber(int dataPartsNumber) {
        ByteBuffer bb = ByteBuffer.allocate(4);
        bb.putInt(dataPartsNumber);
        bb.flip();
        bb.get(this.getContent(), 0, 4);
    }

    public int getJsonStringLen() {
        if (this.getContent() == null || this.getContent().length < 8) {
            return 0;
        }
        ByteBuffer bb = ByteBuffer.allocate(4);
        bb.put(this.getContent(), 4, 4);
        bb.flip();
        return bb.getInt();
    }

    public String getJsonString() throws HeaderPartException {
        if (this.getJsonStringLen() == 0) {
            return null;
        }
        try {
            return new String(this.getContent(), 8, this.getJsonStringLen(), "IBM1047");
        }
        catch (UnsupportedEncodingException e) {
            throw new HeaderPartException(e);
        }
    }

    public void setJsonString(String jsonString) throws HeaderPartException {
        this.setContent(this.getDataPartsNumber(), jsonString);
    }

    public void setKeyValues(Map<String, Object> keyValues) throws HeaderPartException {
        this.setContent(this.getDataPartsNumber(), LegStarHeaderPart.getJsonFromMap(keyValues));
    }

    @Override
    public String toString() {
        StringBuffer sb = new StringBuffer(80);
        sb.append(this.getClass().getSimpleName());
        sb.append("{this=").append(Integer.toHexString(System.identityHashCode(this)));
        sb.append(", dataPartsNumber=").append(this.getDataPartsNumber());
        try {
            sb.append(", jsonString=").append(this.getJsonString());
        }
        catch (HeaderPartException e) {
            sb.append(", jsonString=").append("");
        }
        sb.append("}");
        return sb.toString();
    }

    public static boolean isLegStarHeader(byte[] payload) throws UnsupportedEncodingException {
        return LegStarHeaderPart.isLegStarMessagePart(payload, HEADER_PART_ID);
    }
}

