/*
 * Decompiled with CFR 0.152.
 */
package com.legstar.messaging;

import com.legstar.coxb.host.HostContext;
import com.legstar.coxb.util.ClassLoadingException;
import com.legstar.coxb.util.ClassUtil;
import com.legstar.messaging.ConnectionException;
import com.legstar.messaging.ConnectionFactory;
import com.legstar.messaging.LegStarAddress;

public abstract class HostEndpoint {
    private String _name;
    private String _hostCharset = HostContext.getDefaultHostCharsetName();
    private String _hostUserID;
    private String _hostPassword;
    private boolean _hostTraceMode;
    private int _connectTimeout = 1000;
    private int _receiveTimeout = 5000;
    private String _hostConnectionfactoryClass;
    private ConnectionFactory _hostConnectionfactory;
    private AccessStrategy _hostAccessStrategy = DEFAULT_HOST_ACCESS_STRATEGY;
    private int _hostConnectionPoolSize = 5;
    private int _pooledInvokeTimeout = 3000;
    private long _pooledMaxIdleTime = -1L;
    private long _pooledMaxIdleTimeCheckPeriod = -1L;
    public static final int DEFAULT_CONNECT_TIMEOUT_MSEC = 1000;
    public static final int DEFAULT_RECEIVE_TIMEOUT_MSEC = 5000;
    public static final int DEFAULT_POOLED_INVOKE_TIMEOUT_MSEC = 3000;
    public static final long DEFAULT_POOLED_MAX_IDLE_TIME = -1L;
    public static final long DEFAULT_POOLED_MAX_IDLE_TIME_CHECK_PERIOD = -1L;
    public static final int DEFAULT_POOL_SIZE = 5;
    public static final AccessStrategy DEFAULT_HOST_ACCESS_STRATEGY = AccessStrategy.direct;
    public static final String HOST_ENDPOINT_LABEL = "hostEndpoint";
    public static final String HOST_CHARSET_LABEL = "hostCharset";
    public static final String HOST_USERID_LABEL = "hostUserID";
    public static final String HOST_PASSWORD_LABEL = "hostPassword";
    public static final String HOST_TRACE_LABEL = "hostTraceMode";
    public static final String CONNECT_TIMEOUT_LABEL = "connectTimeout";
    public static final String RECEIVE_TIMEOUT_LABEL = "receiveTimeout";
    public static final String HOST_ACCESS_STRATEGY_LABEL = "hostAccessStrategy";
    public static final String HOST_CONNECTION_FACTORY_CLASS_LABEL = "hostConnectionfactoryClass";
    public static final String HOST_CONNECTION_POOL_SIZE_LABEL = "hostConnectionPoolSize";
    public static final String POOLED_INVOKE_TIMEOUT_LABEL = "pooledInvokeTimeout";
    public static final String POOLED_MAX_IDLE_TIME_LABEL = "pooledMaxIdleTime";
    public static final String POOLED_MAX_IDLE_TIME_CHECK_PERIOD_LABEL = "pooledMaxIdleTimeCheckPeriod";

    public HostEndpoint() {
    }

    public HostEndpoint(ConnectionFactory connectionFactory) {
        this._hostConnectionfactory = connectionFactory;
    }

    public HostEndpoint(HostEndpoint copyFrom) {
        this.setConnectTimeout(copyFrom.getConnectTimeout());
        this.setHostAccessStrategy(copyFrom.getHostAccessStrategy());
        this.setHostCharset(copyFrom.getHostCharset());
        this.setHostConnectionfactory(copyFrom.getHostConnectionfactory());
        this.setHostConnectionPoolSize(copyFrom.getHostConnectionPoolSize());
        this.setHostConnectionfactoryClass(copyFrom.getHostConnectionfactoryClass());
        this.setHostPassword(copyFrom.getHostPassword());
        this.setHostTraceMode(copyFrom.isHostTraceMode());
        this.setHostUserID(copyFrom.getHostUserID());
        this.setName(copyFrom.getName());
        this.setPooledInvokeTimeout(copyFrom.getPooledInvokeTimeout());
        this.setPooledMaxIdleTime(copyFrom.getPooledMaxIdleTime());
        this.setPooledMaxIdleTimeCheckPeriod(copyFrom.getPooledMaxIdleTimeCheckPeriod());
        this.setReceiveTimeout(copyFrom.getReceiveTimeout());
    }

    public String toString() {
        String report = "[hostEndpoint=" + this._name + "," + HOST_CHARSET_LABEL + "=" + this._hostCharset + "," + HOST_USERID_LABEL + "=" + this._hostUserID + "," + HOST_PASSWORD_LABEL + "=" + "********" + "," + HOST_TRACE_LABEL + "=" + this._hostTraceMode + "," + CONNECT_TIMEOUT_LABEL + "=" + this._connectTimeout + "," + RECEIVE_TIMEOUT_LABEL + "=" + this._receiveTimeout + "," + HOST_CONNECTION_FACTORY_CLASS_LABEL + "=" + this._hostConnectionfactoryClass + "," + HOST_ACCESS_STRATEGY_LABEL + "=" + (Object)((Object)this._hostAccessStrategy) + "," + HOST_CONNECTION_POOL_SIZE_LABEL + "=" + this._hostConnectionPoolSize + "," + POOLED_INVOKE_TIMEOUT_LABEL + "=" + this._pooledInvokeTimeout + "," + POOLED_MAX_IDLE_TIME_LABEL + "=" + this._pooledMaxIdleTime + "," + POOLED_MAX_IDLE_TIME_CHECK_PERIOD_LABEL + "=" + this._pooledMaxIdleTimeCheckPeriod + "]";
        return report;
    }

    protected void checkAll() throws ConnectionException {
        if (this.getHostCharset() == null || this.getHostCharset().length() == 0) {
            throw new ConnectionException("No host character set has been provided.");
        }
        this.check();
    }

    public abstract void check() throws ConnectionException;

    public void enrich(LegStarAddress address) {
        if (address.getHostUserID() != null && address.getHostUserID().length() > 0) {
            this.setHostUserID(address.getHostUserID());
        }
        if (address.getHostPassword() != null && address.getHostPassword().length() > 0) {
            this.setHostPassword(address.getHostPassword());
        }
        if (address.getHostCharset() != null && address.getHostCharset().length() > 0) {
            this.setHostCharset(address.getHostCharset());
        }
        if (address.isHostTraceMode()) {
            this.setHostTraceMode(true);
        }
    }

    public String getName() {
        return this._name;
    }

    public void setName(String name) {
        this._name = name;
    }

    public String getHostCharset() {
        return this._hostCharset;
    }

    public void setHostCharset(String hostCharset) {
        this._hostCharset = hostCharset;
    }

    public String getHostUserID() {
        return this._hostUserID;
    }

    public void setHostUserID(String hostUserID) {
        this._hostUserID = hostUserID;
    }

    public String getHostPassword() {
        return this._hostPassword;
    }

    public void setHostPassword(String hostPassword) {
        this._hostPassword = hostPassword;
    }

    public boolean isHostTraceMode() {
        return this._hostTraceMode;
    }

    public void setHostTraceMode(boolean hostTraceMode) {
        this._hostTraceMode = hostTraceMode;
    }

    public String getHostConnectionfactoryClass() {
        return this._hostConnectionfactoryClass;
    }

    public void setHostConnectionfactoryClass(String connectionfactoryClass) {
        this._hostConnectionfactoryClass = connectionfactoryClass;
    }

    public int getHostConnectionPoolSize() {
        return this._hostConnectionPoolSize;
    }

    public void setHostConnectionPoolSize(int connectionPoolSize) {
        this._hostConnectionPoolSize = connectionPoolSize;
    }

    public AccessStrategy getHostAccessStrategy() {
        return this._hostAccessStrategy;
    }

    public void setHostAccessStrategy(AccessStrategy accessStrategy) {
        this._hostAccessStrategy = accessStrategy;
    }

    public int getPooledInvokeTimeout() {
        return this._pooledInvokeTimeout;
    }

    public void setPooledInvokeTimeout(int invokeTimeout) {
        this._pooledInvokeTimeout = invokeTimeout;
    }

    public int getConnectTimeout() {
        return this._connectTimeout;
    }

    public void setConnectTimeout(int timeout) {
        this._connectTimeout = timeout;
    }

    public int getReceiveTimeout() {
        return this._receiveTimeout;
    }

    public void setReceiveTimeout(int timeout) {
        this._receiveTimeout = timeout;
    }

    public ConnectionFactory getHostConnectionfactory() {
        if (this._hostConnectionfactory == null) {
            if (this.getHostConnectionfactoryClass() != null) {
                try {
                    this._hostConnectionfactory = (ConnectionFactory)ClassUtil.newObject(this.getHostConnectionfactoryClass());
                }
                catch (ClassLoadingException e) {
                    throw new IllegalStateException(e);
                }
            } else {
                throw new IllegalStateException("Host endpoint has no connection factory class name");
            }
        }
        return this._hostConnectionfactory;
    }

    public void setHostConnectionfactory(ConnectionFactory connectionfactory) {
        this._hostConnectionfactory = connectionfactory;
    }

    public long getPooledMaxIdleTime() {
        return this._pooledMaxIdleTime;
    }

    public void setPooledMaxIdleTime(long maxIdleTime) {
        this._pooledMaxIdleTime = maxIdleTime;
    }

    public long getPooledMaxIdleTimeCheckPeriod() {
        return this._pooledMaxIdleTimeCheckPeriod;
    }

    public void setPooledMaxIdleTimeCheckPeriod(long pooledMaxIdleTimeCheckPeriod) {
        this._pooledMaxIdleTimeCheckPeriod = pooledMaxIdleTimeCheckPeriod;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum AccessStrategy {
        direct,
        pooled;

    }
}

