/*
 * Decompiled with CFR 0.152.
 */
package com.legstar.host.servlet;

import com.legstar.config.LegStarConfigurationException;
import com.legstar.config.commons.LegStarConfigCommons;
import com.legstar.host.server.EngineHandler;
import com.legstar.host.server.EngineStartupException;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class InitiatorServlet
extends HttpServlet {
    private static final long serialVersionUID = -4200681992731561770L;
    public static final String CONFIG_PARAM = "engine.config";
    public static final String ENGINE_HANDLER_ID = "com.legstar.host.servlet.engineHandler";
    private static final Log LOG = LogFactory.getLog(InitiatorServlet.class);

    public void init(ServletConfig config) throws ServletException {
        String configFileName = config.getInitParameter(CONFIG_PARAM);
        if (configFileName == null || configFileName.length() == 0) {
            throw new ServletException("Web.xml does not contain the engine.config parameter.");
        }
        LOG.info("Initializing with " + configFileName + " configuration file.");
        try {
            LegStarConfigCommons legStarConfig = new LegStarConfigCommons(configFileName);
            EngineHandler serverHandler = new EngineHandler(legStarConfig.getPoolingEngineConfig());
            serverHandler.init();
            ServletContext servletContext = config.getServletContext();
            servletContext.setAttribute(ENGINE_HANDLER_ID, (Object)serverHandler);
        }
        catch (EngineStartupException e) {
            LOG.error("Failed to start engine.", e);
            throw new ServletException((Throwable)e);
        }
        catch (LegStarConfigurationException e) {
            LOG.error("Failed to start engine.", e);
            throw new ServletException((Throwable)e);
        }
    }
}

