/*
 * Decompiled with CFR 0.152.
 */
package com.legstar.host.server;

import com.legstar.config.PoolingEngineConfig;
import com.legstar.host.server.Engine;
import com.legstar.host.server.EngineConfigurationException;
import com.legstar.host.server.EngineListener;
import com.legstar.host.server.EngineNotStartedException;
import com.legstar.host.server.EngineStartupException;
import com.legstar.pool.manager.ConnectionPoolManager;
import com.legstar.work.invoke.InvokeWorkFactory;
import com.legstar.work.manager.WorkManagerImpl;
import commonj.work.WorkManager;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.naming.InitialContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class EngineHolder {
    private static Engine sEngine;
    private static ExecutorService sExecutor;
    private static WorkManager sWorkManager;
    private static ConnectionPoolManager sPoolManager;
    private static PoolingEngineConfig sConfig;
    private static final Log LOG;

    private EngineHolder() {
    }

    public static void preInit(PoolingEngineConfig config) throws EngineConfigurationException {
        sConfig = config;
        sPoolManager = new ConnectionPoolManager(sConfig.getHostEndpoints());
        EngineHolder.initializeWorkManager();
    }

    public static void init() throws EngineStartupException {
        LOG.debug("Starting engine.");
        sEngine = new Engine(sConfig.getMaxRequests(), sWorkManager, sPoolManager, new InvokeWorkFactory(), sConfig.getTakeTimeout());
        try {
            sWorkManager.schedule(sEngine, new EngineListener());
        }
        catch (IllegalArgumentException e) {
            throw new EngineStartupException(e);
        }
    }

    public static void stop() {
        if (sEngine != null) {
            sEngine.shutDown();
            sEngine = null;
        }
        if (sPoolManager != null) {
            sPoolManager.shutDown();
            sPoolManager = null;
        }
        if (sExecutor != null) {
            sExecutor.shutdownNow();
            sExecutor = null;
        }
        sWorkManager = null;
    }

    public static Engine getEngine() throws EngineNotStartedException {
        if (sEngine == null) {
            throw new EngineNotStartedException("The host access engine is not running.");
        }
        if (sEngine.isShuttingDown()) {
            throw new EngineNotStartedException("The host access engine is shutting down.");
        }
        return sEngine;
    }

    private static void initializeWorkManager() {
        LOG.debug("Initializing Work Manager.");
        String workMgrLocation = sConfig.getWorkManagerJNDILocation();
        if (workMgrLocation != null && workMgrLocation.length() > 0) {
            try {
                InitialContext ic = new InitialContext();
                sWorkManager = (WorkManager)ic.lookup(workMgrLocation);
            }
            catch (Exception e) {
                sWorkManager = null;
            }
        } else {
            sWorkManager = null;
        }
        if (sWorkManager == null) {
            int threadPoolSize = sConfig.getThreadPoolSize();
            sExecutor = Executors.newFixedThreadPool(threadPoolSize);
            sWorkManager = new WorkManagerImpl(sExecutor);
        }
    }

    static {
        LOG = LogFactory.getLog(EngineHolder.class);
    }
}

