/*
 * Decompiled with CFR 0.152.
 */
package com.legstar.host.server;

import com.legstar.config.PoolingEngineConfig;
import com.legstar.host.server.Engine;
import com.legstar.host.server.EngineConfigurationException;
import com.legstar.host.server.EngineHolder;
import com.legstar.host.server.EngineNotStartedException;
import com.legstar.host.server.EngineStartupException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class EngineHandler {
    private final Log _log = LogFactory.getLog(EngineHandler.class);
    private PoolingEngineConfig _poolingEngineConfig;

    public EngineHandler(PoolingEngineConfig poolingEngineConfig) {
        this._poolingEngineConfig = poolingEngineConfig;
    }

    public void init() throws EngineStartupException {
        this._log.info("Initializing Engine.");
        try {
            EngineHolder.preInit(this._poolingEngineConfig);
        }
        catch (EngineConfigurationException e) {
            throw new EngineStartupException(e);
        }
        EngineHolder.init();
    }

    public void stop() {
        EngineHolder.stop();
    }

    public Engine getEngine() throws EngineNotStartedException {
        return EngineHolder.getEngine();
    }
}

