/*
 * Decompiled with CFR 0.152.
 */
package com.legstar.host.server;

import com.legstar.host.server.WorkFactory;
import com.legstar.messaging.LegStarConnection;
import com.legstar.messaging.LegStarRequest;
import com.legstar.messaging.RequestException;
import com.legstar.pool.manager.ConnectionPool;
import com.legstar.pool.manager.ConnectionPoolException;
import com.legstar.pool.manager.ConnectionPoolManager;
import commonj.work.Work;
import commonj.work.WorkException;
import commonj.work.WorkListener;
import commonj.work.WorkManager;
import java.util.concurrent.LinkedBlockingQueue;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class Engine
implements Work {
    private LinkedBlockingQueue<LegStarRequest> _requests;
    private boolean _isShuttingDown;
    private WorkManager _workManager;
    private WorkFactory _workFactory;
    private ConnectionPoolManager _poolManager;
    private int _takeTimeout;
    private final Log _log = LogFactory.getLog(Engine.class);

    public Engine(int maxRequests, WorkManager workManager, ConnectionPoolManager poolManager, WorkFactory workFactory, int takeTimeout) {
        this._requests = new LinkedBlockingQueue(maxRequests);
        this._isShuttingDown = false;
        this._workManager = workManager;
        this._poolManager = poolManager;
        this._workFactory = workFactory;
        this._takeTimeout = takeTimeout;
        this._log.debug("Created engine instance:" + this);
    }

    public void run() {
        while (!this._isShuttingDown) {
            this._log.debug("Waiting for requests");
            try {
                LegStarRequest request = this._requests.take();
                if (!this._isShuttingDown) {
                    this.scheduleWork(request);
                    this._log.debug("Scheduled Request:" + request.getID());
                    continue;
                }
                this._log.info("Engine stopped.");
            }
            catch (InterruptedException e) {
                this._log.error("Failed to submit request", e);
            }
            catch (WorkException e) {
                this._log.error("Failed to submit request", e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void scheduleWork(LegStarRequest request) throws WorkException {
        LegStarConnection connection;
        ConnectionPool pool;
        try {
            pool = this._poolManager.getPool(request.getAddress(), true);
            connection = pool.take(this._takeTimeout);
        }
        catch (ConnectionPoolException e) {
            LegStarRequest legStarRequest = request;
            synchronized (legStarRequest) {
                request.setException(new RequestException(e));
                request.signalProcessingStop();
            }
            throw new WorkException(e);
        }
        Work work = this._workFactory.createWork(request, connection);
        WorkListener workListener = this._workFactory.createWorkListener(request, connection, pool);
        this._workManager.schedule(work, workListener);
    }

    public void addRequest(LegStarRequest request) {
        request.signalProcessingStart();
        if (!this._isShuttingDown) {
            this._requests.add(request);
        } else {
            this._log.error("Request received while engine is shutting down.");
        }
    }

    public void shutDown() {
        this._isShuttingDown = true;
        this._log.info("Attempting to shutdown...");
        if (this._requests.size() == 0) {
            this._requests.add(new LegStarRequest());
        } else {
            this._log.warn("Shutdown requested. " + this._requests.size() + " requests are pending.");
        }
    }

    public boolean isShuttingDown() {
        return this._isShuttingDown;
    }

    public boolean isDaemon() {
        return false;
    }

    public void release() {
    }
}

