/*
 * Decompiled with CFR 0.152.
 */
package com.legstar.host.invoke;

import com.legstar.host.invoke.model.HostContainer;
import com.legstar.host.invoke.model.HostProgram;
import com.legstar.host.invoke.model.HostProgramException;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.List;
import java.util.Properties;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HostProgramProperties
extends HostProgram {
    public HostProgramProperties(String fileName) throws HostProgramException {
        try {
            Properties props = this.load(fileName);
            this.setName(props.getProperty("CICSProgramName"));
            String strLength = props.getProperty("CICSLength", "0");
            this.setMaxDataLength(Integer.parseInt(strLength));
            String strDataLength = props.getProperty("CICSDataLength", "0");
            this.setDataLength(Integer.parseInt(strDataLength));
            this.setSysID(props.getProperty("CICSSysID"));
            String strSyncOnReturn = props.getProperty("CICSSyncOnReturn");
            if (strSyncOnReturn != null && strSyncOnReturn.length() > 0) {
                this.setSyncOnReturn(Boolean.parseBoolean(strSyncOnReturn));
            }
            this.setTransID(props.getProperty("CICSTransID"));
            this.setChannelName(props.getProperty("CICSChannel"));
            if (this.getChannelName() != null && this.getChannelName().length() > 0) {
                this.loadContainer(props, this.getInputContainers(), "CICSInContainers", "CICSInContainersLength");
                this.loadContainer(props, this.getOutputContainers(), "CICSOutContainers", "CICSOutContainersLength");
            }
            this.check();
        }
        catch (IOException e) {
            throw new HostProgramException(e);
        }
        catch (NumberFormatException e) {
            throw new HostProgramException("Invalid length", e);
        }
    }

    private void loadContainer(Properties props, List<HostContainer> containers, String nameKey, String lengthKey) throws HostProgramException {
        int i = 1;
        String name = props.getProperty(nameKey + '_' + i);
        while (name != null && name.length() > 0) {
            Integer length = 0;
            String slength = props.getProperty(lengthKey + '_' + i);
            if (slength != null && slength.length() > 0) {
                length = Integer.parseInt(slength);
            }
            HostContainer container = new HostContainer();
            container.setName(name);
            container.setLength(length);
            containers.add(container);
            name = props.getProperty(nameKey + '_' + ++i);
        }
    }

    public Properties load(String propFileName) throws IOException {
        Properties properties = new Properties();
        ClassLoader classLoader = AccessController.doPrivileged(new PrivilegedAction<ClassLoader>(){

            @Override
            public ClassLoader run() {
                return Thread.currentThread().getContextClassLoader();
            }
        });
        InputStream in = classLoader.getResourceAsStream(propFileName);
        if (in == null) {
            throw new FileNotFoundException(propFileName);
        }
        properties.load(in);
        in.close();
        return properties;
    }
}

