/*
 * Decompiled with CFR 0.152.
 */
package com.legstar.host.invoke;

import com.legstar.config.LegStarConfigurationException;
import com.legstar.config.commons.LegStarConfigCommons;
import com.legstar.host.access.HostAccessStrategy;
import com.legstar.host.access.HostAccessStrategyException;
import com.legstar.host.access.HostAccessStrategyFactory;
import com.legstar.host.invoke.CommareaInvoker;
import com.legstar.host.invoke.ContainerInvoker;
import com.legstar.host.invoke.HostInvoker;
import com.legstar.host.invoke.HostInvokerException;
import com.legstar.host.invoke.HostProgramProperties;
import com.legstar.host.invoke.model.HostProgram;
import com.legstar.host.invoke.model.HostProgramException;
import com.legstar.messaging.HostEndpoint;
import com.legstar.messaging.LegStarAddress;

public final class HostInvokerFactory {
    private static LegStarConfigCommons _config;

    private HostInvokerFactory() {
    }

    public static HostInvoker createHostInvoker(String generalConfigFileName, LegStarAddress address, HostProgram hostProgram) throws HostInvokerException {
        try {
            if (_config == null) {
                _config = new LegStarConfigCommons(generalConfigFileName);
            }
            HostEndpoint endpoint = _config.getHostEndpoint(address);
            LegStarAddress completeAddress = new LegStarAddress(address, endpoint);
            HostAccessStrategy hostAccessStrategy = HostAccessStrategyFactory.createAccessStrategy(endpoint);
            String channelName = hostProgram.getChannelName();
            if (channelName != null && channelName.length() > 0) {
                return new ContainerInvoker(hostAccessStrategy, completeAddress, hostProgram);
            }
            return new CommareaInvoker(hostAccessStrategy, completeAddress, hostProgram);
        }
        catch (HostAccessStrategyException e) {
            throw new HostInvokerException(e);
        }
        catch (LegStarConfigurationException e) {
            throw new HostInvokerException(e);
        }
    }

    public static HostInvoker createHostInvoker(String generalConfigFileName, LegStarAddress address, String cicsProgramFileName) throws HostInvokerException {
        try {
            return HostInvokerFactory.createHostInvoker(generalConfigFileName, address, new HostProgramProperties(cicsProgramFileName));
        }
        catch (HostProgramException e) {
            throw new HostInvokerException(e);
        }
    }
}

