/*
 * Decompiled with CFR 0.152.
 */
package com.legstar.host.invoke;

import com.legstar.host.access.HostAccessStrategy;
import com.legstar.host.invoke.AbstractInvoker;
import com.legstar.host.invoke.HostInvokerException;
import com.legstar.host.invoke.model.HostProgram;
import com.legstar.host.invoke.model.HostProgramException;
import com.legstar.messaging.ContainerPart;
import com.legstar.messaging.HeaderPartException;
import com.legstar.messaging.LegStarAddress;
import com.legstar.messaging.LegStarHeaderPart;
import com.legstar.messaging.LegStarMessage;
import com.legstar.messaging.LegStarMessagePart;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ContainerInvoker
extends AbstractInvoker {
    public ContainerInvoker(HostAccessStrategy hostAccessStrategy, LegStarAddress completeAddress, HostProgram hostProgram) throws HostInvokerException {
        super(hostAccessStrategy, completeAddress, hostProgram);
    }

    @Override
    public byte[] invoke(String requestID, byte[] requestBytes) throws HostInvokerException {
        throw new HostInvokerException("Unsupported method for CICS containers");
    }

    @Override
    public Map<String, byte[]> invoke(String requestID, Map<String, byte[]> requestParts) throws HostInvokerException {
        try {
            LegStarMessage requestMessage = new LegStarMessage();
            requestMessage.setHeaderPart(new LegStarHeaderPart(0, this.getHostProgram().toJSONHost()));
            for (Map.Entry<String, byte[]> entry : requestParts.entrySet()) {
                requestMessage.addDataPart(new ContainerPart(entry.getKey(), entry.getValue()));
            }
            LegStarMessage responseMessage = this.invoke(requestID, requestMessage);
            if (responseMessage == null) {
                return null;
            }
            HashMap<String, byte[]> response = new HashMap<String, byte[]>();
            for (LegStarMessagePart part : responseMessage.getDataParts()) {
                response.put(part.getPartID(), part.getContent());
            }
            return response;
        }
        catch (HeaderPartException e) {
            throw new HostInvokerException(e);
        }
        catch (HostProgramException e) {
            throw new HostInvokerException(e);
        }
    }
}

