/*
 * Decompiled with CFR 0.152.
 */
package com.legstar.host.invoke;

import com.legstar.host.invoke.HostInvoker;
import com.legstar.host.invoke.HostInvokerException;
import com.legstar.host.invoke.HostInvokerFactory;
import com.legstar.host.invoke.HostProgramProperties;
import com.legstar.host.invoke.model.HostProgram;
import com.legstar.host.invoke.model.HostProgramException;
import com.legstar.messaging.LegStarAddress;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class AbstractProgramInvoker {
    private String mOperationName;
    private String mProgramProperties;
    private HostProgram mHostProgram;
    private ConcurrentMap<LegStarAddress, HostInvoker> _hostInvokersCache;
    private String mConfigFileName;
    private final Log _log = LogFactory.getLog(this.getClass());

    public AbstractProgramInvoker(String configFileName, String operationName, String programProperties) {
        this(configFileName, operationName, (HostProgram)null);
        try {
            this.mHostProgram = new HostProgramProperties(programProperties);
        }
        catch (HostProgramException e) {
            throw new IllegalArgumentException(e);
        }
        this.mProgramProperties = programProperties;
    }

    public AbstractProgramInvoker(String configFileName, String operationName, HostProgram hostProgram) {
        this.mConfigFileName = configFileName;
        this.mOperationName = operationName;
        this.mHostProgram = hostProgram;
        this._hostInvokersCache = new ConcurrentHashMap<LegStarAddress, HostInvoker>();
    }

    public String toString() {
        StringBuffer details = new StringBuffer();
        details.append("Operation=" + this.getOperationName());
        details.append(", Program properties=" + this.getHostProgram());
        details.append(", Config file name=" + this.getConfigFileName());
        for (Map.Entry entry : this._hostInvokersCache.entrySet()) {
            details.append(", " + ((HostInvoker)entry.getValue()).toString());
        }
        return details.toString();
    }

    public HostInvoker getHostInvoker(LegStarAddress address) throws HostInvokerException {
        LegStarAddress keyAddress = address == null ? new LegStarAddress((String)null) : address;
        HostInvoker hostInvoker = (HostInvoker)this._hostInvokersCache.get(keyAddress);
        if (hostInvoker == null) {
            HostInvoker newHostInvoker;
            if (this._log.isDebugEnabled()) {
                this._log.debug("Creating new host invoker for keyAddress: " + keyAddress);
            }
            if ((hostInvoker = this._hostInvokersCache.putIfAbsent(keyAddress, newHostInvoker = HostInvokerFactory.createHostInvoker(this.getConfigFileName(), keyAddress, this.getHostProgram()))) == null) {
                hostInvoker = newHostInvoker;
            }
        }
        return hostInvoker;
    }

    public String getConfigFileName() {
        return this.mConfigFileName;
    }

    public String getProgramProperties() {
        return this.mProgramProperties;
    }

    public HostProgram getHostProgram() {
        return this.mHostProgram;
    }

    public String getOperationName() {
        return this.mOperationName;
    }
}

