/*
 * Decompiled with CFR 0.152.
 */
package com.legstar.host.invoke;

import com.legstar.host.access.HostAccessStrategy;
import com.legstar.host.access.HostAccessStrategyException;
import com.legstar.host.invoke.HostInvoker;
import com.legstar.host.invoke.HostInvokerException;
import com.legstar.host.invoke.HostProgramProperties;
import com.legstar.host.invoke.model.HostProgram;
import com.legstar.messaging.LegStarAddress;
import com.legstar.messaging.LegStarMessage;
import com.legstar.messaging.LegStarRequest;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class AbstractInvoker
implements HostInvoker {
    private HostAccessStrategy mHostAccessStrategy;
    private LegStarAddress mAddress;
    private HostProgram mHostProgram;
    private final Log _log = LogFactory.getLog(AbstractInvoker.class);

    public AbstractInvoker(HostAccessStrategy hostAccessStrategy, LegStarAddress completeAddress, HostProgram hostProgram) throws HostInvokerException {
        this.mHostAccessStrategy = hostAccessStrategy;
        this.mAddress = completeAddress;
        this.mHostProgram = hostProgram;
    }

    public LegStarMessage invoke(String requestID, LegStarMessage requestMessage) throws HostInvokerException {
        long start = System.currentTimeMillis();
        if (this._log.isDebugEnabled()) {
            this._log.debug("Invoke mainframe started");
        }
        LegStarRequest request = new LegStarRequest(requestID, this.getAddress(), requestMessage);
        try {
            this.getHostAccessStrategy().invoke(request);
        }
        catch (HostAccessStrategyException e) {
            throw new HostInvokerException(e);
        }
        if (request.getException() != null) {
            throw new HostInvokerException(request.getException());
        }
        if (this._log.isDebugEnabled()) {
            long end = System.currentTimeMillis();
            this._log.debug("Invoke mainframe ended. elapse: " + Long.toString(end - start) + " ms");
        }
        return request.getResponseMessage();
    }

    public LegStarAddress getAddress() {
        return this.mAddress;
    }

    public HostAccessStrategy getHostAccessStrategy() {
        return this.mHostAccessStrategy;
    }

    public HostProgram getHostProgram() {
        return this.mHostProgram;
    }

    public HostProgramProperties getProgramAttr() {
        return null;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("HostInvoker=[");
        if (this.getAddress() != null) {
            sb.append(this.getAddress().toString() + ",");
        }
        sb.append("HostAccessStrategy=" + this.getHostAccessStrategy().getClass().getName());
        sb.append("," + this.getHostProgram().toString());
        sb.append("]");
        return sb.toString();
    }
}

