/*
 * Decompiled with CFR 0.152.
 */
package com.legstar.host.access;

import com.legstar.host.access.HostAccessStrategy;
import com.legstar.host.access.HostAccessStrategyException;
import com.legstar.host.server.EngineHolder;
import com.legstar.host.server.EngineNotStartedException;
import com.legstar.messaging.HostEndpoint;
import com.legstar.messaging.LegStarRequest;
import java.util.concurrent.TimeUnit;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class PooledHostAccessStrategy
implements HostAccessStrategy {
    private final Log _log = LogFactory.getLog(this.getClass());
    private long mInvokeTimeout;

    public PooledHostAccessStrategy(HostEndpoint hostEndpoint) {
        this.mInvokeTimeout = hostEndpoint.getPooledInvokeTimeout();
    }

    public void invoke(LegStarRequest request) throws HostAccessStrategyException {
        long startTime = System.currentTimeMillis();
        if (this._log.isDebugEnabled()) {
            this._log.debug("Pooled invoke for Request:" + request.getID());
        }
        try {
            EngineHolder.getEngine().addRequest(request);
            request.await(this.mInvokeTimeout, TimeUnit.MILLISECONDS);
            if (request.getException() != null) {
                throw new HostAccessStrategyException(request.getException());
            }
            if (request.getResponseMessage() == null) {
                throw new HostAccessStrategyException("Timed out waiting for a response for Request:" + request.getID());
            }
        }
        catch (InterruptedException e) {
            throw new HostAccessStrategyException(e);
        }
        catch (EngineNotStartedException e) {
            throw new HostAccessStrategyException(e);
        }
        if (this._log.isDebugEnabled()) {
            long endTime = System.currentTimeMillis();
            this._log.debug("Pooled invoke for Request:" + request.getID() + " ended. elapse: " + Long.toString(endTime - startTime) + " ms");
        }
    }

    public long getInvokeTimeout() {
        return this.mInvokeTimeout;
    }

    public void setInvokeTimeout(long invokeTimeout) {
        this.mInvokeTimeout = invokeTimeout;
    }
}

