/*
 * Decompiled with CFR 0.152.
 */
package com.legstar.host.access;

import com.legstar.host.access.DirectHostAccessStrategy;
import com.legstar.host.access.HostAccessStrategy;
import com.legstar.host.access.HostAccessStrategyException;
import com.legstar.host.access.PooledHostAccessStrategy;
import com.legstar.messaging.HostEndpoint;

public final class HostAccessStrategyFactory {
    private HostAccessStrategyFactory() {
    }

    public static HostAccessStrategy createAccessStrategy(HostEndpoint endpoint) throws HostAccessStrategyException {
        if (endpoint.getHostAccessStrategy() == HostEndpoint.AccessStrategy.direct) {
            return new DirectHostAccessStrategy(endpoint);
        }
        if (endpoint.getHostAccessStrategy() == HostEndpoint.AccessStrategy.pooled) {
            return new PooledHostAccessStrategy(endpoint);
        }
        throw new HostAccessStrategyException("Unknown host access strategy.");
    }
}

