/*
 * Decompiled with CFR 0.152.
 */
package com.legstar.host.access;

import com.legstar.host.access.HostAccessStrategy;
import com.legstar.host.access.HostAccessStrategyException;
import com.legstar.messaging.ConnectionException;
import com.legstar.messaging.ConnectionFactory;
import com.legstar.messaging.HostEndpoint;
import com.legstar.messaging.LegStarConnection;
import com.legstar.messaging.LegStarRequest;
import com.legstar.messaging.RequestException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DirectHostAccessStrategy
implements HostAccessStrategy {
    private final Log _log = LogFactory.getLog(this.getClass());
    private HostEndpoint _hostEndpoint;

    public DirectHostAccessStrategy(HostEndpoint hostEndpoint) {
        this._hostEndpoint = hostEndpoint;
    }

    public void invoke(LegStarRequest request) throws HostAccessStrategyException {
        long startTime = System.currentTimeMillis();
        if (this._log.isDebugEnabled()) {
            this._log.debug("Direct invoke for Request:" + request.getID());
        }
        try {
            ConnectionFactory factory = this.getHostEndpoint().getHostConnectionfactory();
            LegStarConnection connection = factory.createConnection(request.getID(), request.getAddress(), this.getHostEndpoint());
            connection.connect(request.getAddress().getHostPassword());
            connection.sendRequest(request);
            connection.recvResponse(request);
            connection.close();
        }
        catch (ConnectionException e) {
            request.setException(new RequestException(e));
            throw new HostAccessStrategyException(e);
        }
        catch (RequestException e) {
            request.setException(new RequestException(e));
            throw new HostAccessStrategyException(e);
        }
        if (this._log.isDebugEnabled()) {
            long endTime = System.currentTimeMillis();
            this._log.debug("Direct invoke for Request:" + request.getID() + " ended. elapse: " + Long.toString(endTime - startTime) + " ms");
        }
    }

    public HostEndpoint getHostEndpoint() {
        return this._hostEndpoint;
    }
}

