/*
 * Decompiled with CFR 0.152.
 */
package com.legstar.csok.client;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class CicsSocketOutputBuffer {
    private int mOutputBufferLen;
    private byte[] mOutputBuffer;
    private int mPos;
    private OutputStream mOutputStream;

    public CicsSocketOutputBuffer(OutputStream out, int bufferLen) {
        this.mOutputStream = out;
        this.mOutputBufferLen = bufferLen;
        this.mOutputBuffer = new byte[bufferLen];
        this.mPos = 0;
    }

    public void write(byte[] buffer) throws IOException {
        this.write(buffer, 0, buffer.length);
    }

    public void write(byte[] buffer, int len) throws IOException {
        this.write(buffer, 0, len);
    }

    public void write(byte[] buffer, int off, int len) throws IOException {
        if (len > this.mOutputBufferLen) {
            this.flush();
            this.mOutputStream.write(buffer, off, len);
            return;
        }
        if (len > this.mOutputBufferLen - this.mPos) {
            this.flush();
            this.write(buffer, off, len);
            return;
        }
        System.arraycopy(buffer, off, this.mOutputBuffer, this.mPos, len);
        this.mPos += len;
    }

    public void write(InputStream inStream) throws IOException {
        int rc;
        byte[] buffer = new byte[1024];
        while ((rc = inStream.read(buffer)) > 0) {
            this.write(buffer, 0, rc);
        }
    }

    public void flush() throws IOException {
        if (this.mPos > 0) {
            this.mOutputStream.write(this.mOutputBuffer, 0, this.mPos);
            this.mPos = 0;
        }
    }
}

