/*
 * Decompiled with CFR 0.152.
 */
package com.legstar.csok.client;

import com.legstar.csok.client.CicsSocketConnectionException;
import com.legstar.messaging.ConnectionFactory;
import com.legstar.messaging.HostEndpoint;

public class CicsSocketEndpoint
extends HostEndpoint {
    private String mHostIPAddress;
    private int mHostIPPort;
    private static final String DEFAULT_CONNECTION_FACTORY_CLASS = "com.legstar.csok.client.CicsSocketConnectionFactory";
    private static final String IP_ADDRESS_LABEL = "hostIPAddress";
    private static final String IP_PORT_LABEL = "hostIPPort";

    public CicsSocketEndpoint() {
        this.setHostConnectionfactoryClass(DEFAULT_CONNECTION_FACTORY_CLASS);
    }

    public CicsSocketEndpoint(ConnectionFactory connectionFactory) {
        super(connectionFactory);
    }

    public CicsSocketEndpoint(CicsSocketEndpoint copyFrom) {
        super(copyFrom);
        this.setHostIPAddress(copyFrom.getHostIPAddress());
        this.setHostIPPort(copyFrom.getHostIPPort());
    }

    public void check() throws CicsSocketConnectionException {
        if (this.getHostIPAddress() == null || this.getHostIPAddress().length() == 0) {
            throw new CicsSocketConnectionException("No host IP address has been provided.");
        }
        if (this.getHostIPPort() == 0) {
            throw new CicsSocketConnectionException("No host IP port has been provided.");
        }
    }

    public String toString() {
        String report = "CICS Socket endpoint:" + super.toString() + "[" + IP_ADDRESS_LABEL + "=" + this.mHostIPAddress + "," + IP_PORT_LABEL + "=" + this.mHostIPPort + "]";
        return report;
    }

    public String getHostIPAddress() {
        return this.mHostIPAddress;
    }

    public void setHostIPAddress(String hostIPAddress) {
        this.mHostIPAddress = hostIPAddress;
    }

    public int getHostIPPort() {
        return this.mHostIPPort;
    }

    public void setHostIPPort(int hostIPPort) {
        this.mHostIPPort = hostIPPort;
    }
}

