/*
 * Decompiled with CFR 0.152.
 */
package com.legstar.csok.client;

import com.legstar.codec.HostCodec;
import com.legstar.csok.client.CicsSocketEndpoint;
import com.legstar.csok.client.CicsSocketOutputBuffer;
import com.legstar.messaging.ConnectionException;
import com.legstar.messaging.HeaderPartException;
import com.legstar.messaging.HostMessageFormatException;
import com.legstar.messaging.LegStarConnection;
import com.legstar.messaging.LegStarMessage;
import com.legstar.messaging.LegStarRequest;
import com.legstar.messaging.RequestException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class CicsSocket
implements LegStarConnection {
    private static final int CIM_LEN = 35;
    private static final int CICS_USERID_LEN = 8;
    private static final int CICS_PWD_LEN = 8;
    private static final int CONNECTION_ID_LEN = 16;
    private static final int MSG_TYPE_LEN = 9;
    private static final int REPLY_HDR_LEN = 9;
    private static final int TRACE_LEN = 1;
    private static final int MAX_PROT_REPLY_LEN = 266;
    private static final String CIM_EYE_CATCHER = "SK";
    private static final String EXEC_REQUEST_EC = "LSOKEXEC";
    private static final String PROBE_REQUEST_EC = "LSOKPROB";
    private static final String REPLY_ACK_MSG_EC = "LSOKACK0";
    private static final String REPLY_ERROR_MSG_EC = "LSOKERR0";
    private static final String DATA_MSG_EC = "LSOKDATA";
    private static final String UOW_MSG_EC = "LSOKUOWC";
    private static final int UOW_MSG_EC_LEN = 8;
    private static final int UOW_COMMAND_LEN = 8;
    public static final String UOW_COMMIT = "Commit";
    public static final String UOW_ROLLBACK = "Rollback";
    public static final String UOW_KEEP = "Keep";
    public static final String PROTOCOL_ERROR_MSG = "Invalid or unexpected reply from host.";
    private Socket mClientSocket = null;
    private String mConnectionID;
    private CicsSocketEndpoint mCicsSocketEndpoint;
    private String mHostProtocolCharset;
    private long _lastUsedTime = -1L;
    private boolean _isOpen;
    private final Log _log = LogFactory.getLog(CicsSocket.class);

    public CicsSocket(String connectionID, CicsSocketEndpoint cicsSocketEndpoint) {
        this.mConnectionID = connectionID;
        this.mCicsSocketEndpoint = cicsSocketEndpoint;
        this.mHostProtocolCharset = "IBM1047";
    }

    public void connect(String cicsPassword) throws ConnectionException {
        if (this._log.isDebugEnabled()) {
            this._log.debug("Connection:" + this.mConnectionID + " Attempting connection. Host:" + this.mCicsSocketEndpoint.toString());
        }
        try {
            this.mClientSocket = new Socket();
            this.mClientSocket.connect(new InetSocketAddress(InetAddress.getByName(this.mCicsSocketEndpoint.getHostIPAddress()), this.mCicsSocketEndpoint.getHostIPPort()), this.getCicsSocketEndpoint().getConnectTimeout());
            this.mClientSocket.setSoTimeout(this.getCicsSocketEndpoint().getReceiveTimeout());
            this.mClientSocket.setTcpNoDelay(true);
            this.mClientSocket.setSoLinger(false, 0);
            String password = cicsPassword == null || cicsPassword.length() == 0 ? this.mCicsSocketEndpoint.getHostPassword() : cicsPassword;
            OutputStream out = this.mClientSocket.getOutputStream();
            out.write(CicsSocket.formatCIM(this.mCicsSocketEndpoint.getHostUserID(), password, this.mConnectionID, this.mCicsSocketEndpoint.isHostTraceMode(), this.mHostProtocolCharset));
            this.recvConnectionAck();
            this._isOpen = true;
            this._lastUsedTime = System.currentTimeMillis();
        }
        catch (UnknownHostException e) {
            throw new ConnectionException(e);
        }
        catch (IOException e) {
            throw new ConnectionException(e);
        }
        catch (RequestException e) {
            throw new ConnectionException(e);
        }
        if (this._log.isDebugEnabled()) {
            this._log.debug("Connection:" + this.mConnectionID + " Connected.");
        }
    }

    public void connectReuse(String cicsPassword) throws ConnectionException {
        if (this._log.isDebugEnabled()) {
            this._log.debug("Connection:" + this.mConnectionID + " Attempting reuse.");
        }
        if (this.mClientSocket != null && this.mClientSocket.isConnected() && this.isServerAlive()) {
            if (this._log.isDebugEnabled()) {
                this._log.debug("Connection:" + this.mConnectionID + " Socket will be reused.");
            }
            this._lastUsedTime = System.currentTimeMillis();
            return;
        }
        if (this._log.isDebugEnabled()) {
            this._log.debug("Connection:" + this.mConnectionID + " Socket not reusable.");
        }
        this.connect(cicsPassword);
    }

    private void recvConnectionAck() throws RequestException {
        String ackString = null;
        try {
            InputStream in = this.mClientSocket.getInputStream();
            ackString = CicsSocket.getCharsFromHost(in, this.mHostProtocolCharset, 266);
            if (ackString == null || ackString.length() == 0) {
                throw new RequestException("No response from host.");
            }
            if (REPLY_ACK_MSG_EC.compareTo(ackString.substring(0, REPLY_ACK_MSG_EC.length())) != 0) {
                if (Character.getType(ackString.charAt(0)) == 1) {
                    throw new RequestException(ackString);
                }
                throw new RequestException("Unrecognized response from host.");
            }
        }
        catch (IOException e) {
            throw new RequestException(e);
        }
        if (this._log.isDebugEnabled()) {
            this._log.debug("Connection:" + this.mConnectionID + " Connection Ack received." + ackString);
        }
    }

    public void sendRequest(LegStarRequest request) throws RequestException {
        if (this._log.isDebugEnabled()) {
            try {
                this._log.debug("Sending Request:" + request.getID() + " on Connection:" + this.mConnectionID + " " + request.getRequestMessage().getHeaderPart().getJsonString() + '.');
            }
            catch (HeaderPartException e) {
                throw new RequestException(e);
            }
        }
        CicsSocketOutputBuffer outputBuffer = null;
        try {
            outputBuffer = new CicsSocketOutputBuffer(this.mClientSocket.getOutputStream(), this.mClientSocket.getSendBufferSize());
            outputBuffer.write(CicsSocket.formatMessageType(EXEC_REQUEST_EC, this.mHostProtocolCharset));
            outputBuffer.write(request.getRequestMessage().sendToHost());
            outputBuffer.flush();
        }
        catch (IOException e) {
            throw new RequestException(e);
        }
        catch (HostMessageFormatException e) {
            throw new RequestException(e);
        }
        this._lastUsedTime = System.currentTimeMillis();
        if (this._log.isDebugEnabled()) {
            this._log.debug("Request:" + request.getID() + " on Connection:" + this.mConnectionID + " message request sent.");
        }
    }

    public void recvResponse(LegStarRequest request) throws RequestException {
        if (this._log.isDebugEnabled()) {
            this._log.debug("Receiving response for Request:" + request.getID() + " on Connection:" + this.mConnectionID + '.');
        }
        try {
            InputStream respStream = this.mClientSocket.getInputStream();
            String msgType = this.recvMessageType(respStream);
            if (DATA_MSG_EC.compareTo(msgType.substring(0, DATA_MSG_EC.length())) != 0) {
                this.recvError(msgType, respStream);
            }
            LegStarMessage reponseMessage = new LegStarMessage();
            reponseMessage.recvFromHost(respStream);
            request.setResponseMessage(reponseMessage);
        }
        catch (IOException e) {
            throw new RequestException(e);
        }
        catch (HeaderPartException e) {
            throw new RequestException(e);
        }
        catch (HostMessageFormatException e) {
            throw new RequestException(e);
        }
        this._lastUsedTime = System.currentTimeMillis();
        if (this._log.isDebugEnabled()) {
            this._log.debug("Request:" + request.getID() + " on Connection:" + this.mConnectionID + " response received.");
        }
    }

    private String recvMessageType(InputStream in) throws RequestException {
        String msgType = CicsSocket.getCharsFromHost(in, this.mHostProtocolCharset, 9);
        if (msgType == null || msgType.length() < 9) {
            throw new RequestException("Invalid or unexpected reply from host. message type received: " + msgType);
        }
        return msgType;
    }

    private void recvError(String msgType, InputStream in) throws RequestException {
        if (REPLY_ERROR_MSG_EC.compareTo(msgType.substring(0, REPLY_ERROR_MSG_EC.length())) != 0) {
            String errString = CicsSocket.getCharsFromHost(in, this.mHostProtocolCharset, 266);
            throw new RequestException(msgType + errString);
        }
        String errString = CicsSocket.getCharsFromHost(in, this.mHostProtocolCharset, 266);
        throw new RequestException(errString.trim());
    }

    public void close() throws RequestException {
        if (this._log.isDebugEnabled()) {
            this._log.debug("Connection:" + this.mConnectionID + " Attempting to close.");
        }
        if (this.mClientSocket == null) {
            return;
        }
        if (!this.mClientSocket.isClosed()) {
            try {
                this.mClientSocket.close();
            }
            catch (IOException e) {
                throw new RequestException(e);
            }
        }
        this.mClientSocket = null;
        this._isOpen = false;
        this._lastUsedTime = System.currentTimeMillis();
        if (this._log.isDebugEnabled()) {
            this._log.debug("Connection:" + this.mConnectionID + " Closed.");
        }
    }

    public void commitUOW() throws RequestException {
        this.processUOW(UOW_COMMIT);
    }

    public void keepUOW() throws RequestException {
        this.processUOW(UOW_KEEP);
    }

    public void rollbackUOW() throws RequestException {
        this.processUOW(UOW_ROLLBACK);
    }

    private void processUOW(String command) throws RequestException {
        if (!this.isOpen()) {
            if (this._log.isDebugEnabled()) {
                this._log.debug("Connection:" + this.mConnectionID + " Attempting to " + command + " unit of work on a closed connection. Ignoring.");
            }
            return;
        }
        if (this._log.isDebugEnabled()) {
            this._log.debug("Connection:" + this.mConnectionID + " Attempting to " + command + " unit of work.");
        }
        try {
            OutputStream out = this.mClientSocket.getOutputStream();
            out.write(CicsSocket.formatUOW(command, this.mHostProtocolCharset));
            this.receiveAck();
        }
        catch (IOException e) {
            throw new RequestException(e);
        }
        if (this._log.isDebugEnabled()) {
            this._log.debug("Connection:" + this.mConnectionID + " " + command + " success.");
        }
    }

    private boolean isServerAlive() {
        if (this._log.isDebugEnabled()) {
            this._log.debug("Connection:" + this.mConnectionID + " Attempting to probe server.");
        }
        try {
            OutputStream out = this.mClientSocket.getOutputStream();
            out.write(CicsSocket.formatProbe(this.mHostProtocolCharset));
            this.receiveAck();
            return true;
        }
        catch (IOException e) {
            return false;
        }
        catch (RequestException e) {
            return false;
        }
    }

    private void receiveAck() throws RequestException {
        try {
            InputStream in = this.mClientSocket.getInputStream();
            String msgType = this.recvMessageType(in);
            if (REPLY_ACK_MSG_EC.compareTo(msgType.substring(0, REPLY_ACK_MSG_EC.length())) != 0) {
                this.recvError(msgType, in);
            }
        }
        catch (IOException e) {
            throw new RequestException(e);
        }
        if (this._log.isDebugEnabled()) {
            this._log.debug("Connection:" + this.mConnectionID + " Ack received.");
        }
    }

    private static String getCharsFromHost(InputStream in, String charset, int maxSize) throws RequestException {
        String str = null;
        try {
            byte[] buffer = new byte[maxSize];
            int size = in.read(buffer);
            if (size == -1) {
                return null;
            }
            str = new String(buffer, 0, size, charset);
        }
        catch (UnsupportedEncodingException e) {
            throw new RequestException(e);
        }
        catch (IOException e) {
            throw new RequestException(e);
        }
        return str;
    }

    public static byte[] formatCIM(String cicsUserID, String cicsPassword, String connectionID, boolean trace, String charset) throws UnsupportedEncodingException {
        byte[] cicsCIM = new byte[35];
        int pos = 0;
        HostCodec.toHostBytes(cicsUserID, cicsCIM, pos, 8, charset);
        HostCodec.toHostBytes(cicsPassword, cicsCIM, pos += 8, 8, charset);
        HostCodec.toHostBytes(connectionID, cicsCIM, pos += 8, 16, charset);
        pos += 16;
        if (trace) {
            HostCodec.toHostBytes("1", cicsCIM, pos, 1, charset);
        } else {
            HostCodec.toHostBytes("0", cicsCIM, pos, 1, charset);
        }
        HostCodec.toHostBytes(CIM_EYE_CATCHER, cicsCIM, ++pos, CIM_EYE_CATCHER.length(), charset);
        pos += CIM_EYE_CATCHER.length();
        return cicsCIM;
    }

    public static byte[] formatMessageType(String messageType, String charset) throws UnsupportedEncodingException {
        byte[] aMTBytes = new byte[9];
        int pos = 0;
        HostCodec.toHostBytes(messageType, aMTBytes, pos, 9, charset);
        return aMTBytes;
    }

    public static byte[] formatUOW(String command, String charset) throws UnsupportedEncodingException {
        byte[] aUOWBytes = new byte[18];
        int pos = 0;
        HostCodec.toHostBytes(UOW_MSG_EC, aUOWBytes, pos, 8, charset);
        HostCodec.toHostBytes(command, aUOWBytes, pos += 9, command.length(), charset);
        return aUOWBytes;
    }

    public static byte[] formatProbe(String charset) throws UnsupportedEncodingException {
        byte[] probeBytes = new byte[PROBE_REQUEST_EC.length() + 1];
        int pos = 0;
        HostCodec.toHostBytes(PROBE_REQUEST_EC, probeBytes, pos, PROBE_REQUEST_EC.length(), charset);
        return probeBytes;
    }

    public Socket getClientSocket() {
        return this.mClientSocket;
    }

    public void setClientSocket(Socket clientSocket) {
        this.mClientSocket = clientSocket;
    }

    public CicsSocketEndpoint getCicsSocketEndpoint() {
        return this.mCicsSocketEndpoint;
    }

    public void setCicsSocketEndpoint(CicsSocketEndpoint cicsSocketEndpoint) {
        this.mCicsSocketEndpoint = cicsSocketEndpoint;
    }

    public String getConnectionID() {
        return this.mConnectionID;
    }

    public void setConnectionID(String connectionID) {
        this.mConnectionID = connectionID;
    }

    public long getConnectTimeout() {
        return this.getCicsSocketEndpoint().getConnectTimeout();
    }

    public long getReceiveTimeout() {
        return this.getCicsSocketEndpoint().getReceiveTimeout();
    }

    public boolean isOpen() {
        return this._isOpen;
    }

    public long getLastUsedTime() {
        return this._lastUsedTime;
    }
}

